package com.ebmwebsourcing.easyschema10.impl;

import com.ebmwebsourcing.easybox.api.XmlContext;
import com.ebmwebsourcing.easyschema10.api.element.Element;
import com.ebmwebsourcing.easyschema10.api.with.WithElements;

import easybox.org.w3._2001.xmlschema.EJaxbGroup;

abstract class AbstractElementsImpl<Model extends EJaxbGroup> extends AbstractAnnotatedImpl<Model> implements
        WithElements {

    protected AbstractElementsImpl(XmlContext xmlContext, Model jaxbModel) {
        super(xmlContext, jaxbModel);
    }
    

    public final void addElement(Element element) {
        addToChildren(getModelObject().getParticle(), (ElementImpl) element);
    }

    public final void clearElements() {
        clearChildren(getModelObject().getParticle(),
                easybox.org.w3._2001.xmlschema.EJaxbElement.class, ANY_QNAME);
    }

    @Override
    public final Element getElementByName(String name) {
        return getChildByName(getElements(), name);
    }

    public final Element[] getElements() {
        return createChildrenArray(getModelObject().getParticle(),
                easybox.org.w3._2001.xmlschema.EJaxbElement.class, ANY_QNAME, Element.class);
    }


    public final void removeElement(Element element) {
        removeFromChildren(getModelObject().getParticle(),
                (ElementImpl) element);
    }

    

}
