package com.ebmwebsourcing.easyschema10.impl;

import javax.xml.namespace.QName;

import com.ebmwebsourcing.easybox.api.XmlContext;
import com.ebmwebsourcing.easyschema10.api.element.Attribute;
import com.ebmwebsourcing.easyschema10.api.element.AttributeGroup;

import easybox.org.w3._2001.xmlschema.EJaxbAttribute;
import easybox.org.w3._2001.xmlschema.EJaxbAttributeGroup;
import easybox.org.w3._2001.xmlschema.EJaxbNamedAttributeGroup;

final class AttributeGroupImpl extends AbstractAnnotatedImpl<EJaxbAttributeGroup> implements
        com.ebmwebsourcing.easyschema10.api.element.AttributeGroup {

    AttributeGroupImpl(XmlContext xmlContext, EJaxbAttributeGroup jaxbModel) {
        super(xmlContext, jaxbModel);
    }

    @Override
    protected Class<? extends EJaxbAttributeGroup> getCompliantModelClass() {
        return EJaxbNamedAttributeGroup.class;
    }

    @Override
    public void addAttribute(Attribute attribute) {
        addToChildren(getModelObject().getAttributeOrAttributeGroup(),
                (AttributeImpl) attribute);
    }

    @Override
    public void addAttributeGroup(
            com.ebmwebsourcing.easyschema10.api.element.AttributeGroup attributeGroup) {
        addToChildren(getModelObject().getAttributeOrAttributeGroup(),
                (AttributeGroupImpl) attributeGroup);
    }

    @Override
    public void clearAttributeGroups() {
        clearChildren(getModelObject().getAttributeOrAttributeGroup(),
                EJaxbAttributeGroup.class, ANY_QNAME);
    }

    @Override
    public void clearAttributes() {
        clearChildren(getModelObject().getAttributeOrAttributeGroup(),
                EJaxbAttribute.class, ANY_QNAME);
    }

    @Override
    public Attribute getAttributeByName(String name) {
        return getChildByName(getAttributes(), name);
    }

    @Override
    public AttributeGroup getAttributeGroupByName(String name) {
        return getChildByName(getAttributeGroups(), name);
    }

    @Override
    public com.ebmwebsourcing.easyschema10.api.element.AttributeGroup[] getAttributeGroups() {
        return createChildrenArray(getModelObject()
                .getAttributeOrAttributeGroup(), EJaxbAttributeGroup.class, ANY_QNAME, 
                AttributeGroup.class);
    }

    @Override
    public Attribute[] getAttributes() {
        return createChildrenArray(getModelObject()
                .getAttributeOrAttributeGroup(), EJaxbAttribute.class, ANY_QNAME, 
                Attribute.class);
    }

    @Override
    public String getName() {
        return getModelObject().getName();
    }

    @Override
    public QName getRef() {
        return getModelObject().getRef();
    }

    @Override
    public boolean hasName() {
        return getModelObject().getName() != null;
    }

    @Override
    public boolean hasRef() {
        return getModelObject().getRef() != null;
    }

    @Override
    public void removeAttribute(Attribute attribute) {
        removeFromChildren(getModelObject().getAttributeOrAttributeGroup(),
                (AttributeImpl) attribute);
    }

    @Override
    public void removeAttributeGroup(
            com.ebmwebsourcing.easyschema10.api.element.AttributeGroup attributeGroup) {
        removeFromChildren(getModelObject().getAttributeOrAttributeGroup(),
                (AttributeGroupImpl) attributeGroup);
    }

    @Override
    public void setName(String name) {
        getModelObject().setName(name);
    }

    @Override
    public void setRef(QName ref) {
        getModelObject().setRef(ref);
    }

}
