package com.ebmwebsourcing.easyschema10.impl;

import java.util.Arrays;

import com.ebmwebsourcing.easybox.api.XmlContext;
import com.ebmwebsourcing.easybox.api.XmlObject;
import com.ebmwebsourcing.easybox.impl.JaxbDuplicator;
import com.ebmwebsourcing.easyschema10.api.element.Schema;

import easybox.org.w3._2001.xmlschema.EJaxbLocalSimpleType;
import easybox.org.w3._2001.xmlschema.EJaxbSimpleType;
import easybox.org.w3._2001.xmlschema.EJaxbTopLevelSimpleType;

final class SimpleTypeImpl extends AbstractTypeImpl<EJaxbSimpleType> implements
        com.ebmwebsourcing.easyschema10.api.element.SimpleType {

    protected SimpleTypeImpl(XmlContext xmlContext, EJaxbSimpleType jaxbModel) {
        super(xmlContext, jaxbModel);
    }

    @Override
    protected Class<? extends EJaxbSimpleType> getCompliantModelClass() {
        if (getXmlObjectParent() instanceof SchemaImpl) {
            return EJaxbTopLevelSimpleType.class;
        } else {
            return EJaxbLocalSimpleType.class;
        }
    }
    
    @Override
    public String getName() {
        EJaxbSimpleType simpleType = (EJaxbSimpleType) getModelObject();
        return simpleType.getName();
    }

    @Override
    public boolean hasName() {
        return getModelObject().getName() != null;
    }

    @Override
    public void setName(String name) {
        EJaxbSimpleType simpleType = (EJaxbSimpleType) getModelObject();
        simpleType.setName(name);
    }

    @Override
    public boolean hasFinal() {
        return getModelObject().isSetFinal();
    }

    @Override
    public String[] getFinal() {
        if (!hasFinal())
            return null;
        return getModelObject().getFinal().toArray(
                new String[getModelObject().getFinal().size()]);
    }

    @Override
    public void setFinal(String[] finalStrings) {
        getModelObject().unsetFinal();
        if (finalStrings != null) {
            getModelObject().getFinal().addAll(Arrays.asList(finalStrings));
        }
    }

    
    @Override
    protected void adaptModelObjectIfNecessary() {
        XmlObject naturalParent = getXmlObjectParent();
        if (naturalParent instanceof Schema) {
            setModelObject(JaxbDuplicator.duplicateAs(getModelObject(), EJaxbTopLevelSimpleType.class));
        } else {
            setModelObject(JaxbDuplicator.duplicateAs(getModelObject(), EJaxbLocalSimpleType.class));
        }
        super.adaptModelObjectIfNecessary();
    }
    

}
