package com.ebmwebsourcing.easyschema10.impl;

import com.ebmwebsourcing.easybox.api.XmlContext;
import com.ebmwebsourcing.easybox.impl.AbstractJaxbModelObject;
import com.ebmwebsourcing.easybox.impl.JaxbDuplicator;
import com.ebmwebsourcing.easyschema10.api.element.ComplexContent;
import com.ebmwebsourcing.easyschema10.api.type.ExtensionType;
import com.ebmwebsourcing.easyschema10.api.type.RestrictionType;

import easybox.org.w3._2001.xmlschema.EJaxbComplexContent;
import easybox.org.w3._2001.xmlschema.EJaxbComplexRestrictionType;

final class ComplexContentImpl extends AbstractAnnotatedImpl<EJaxbComplexContent> implements
        ComplexContent {

    protected ComplexContentImpl(XmlContext xmlContext, EJaxbComplexContent jaxbModel) {
        super(xmlContext, jaxbModel);
    }
    
    @Override
    protected Class<? extends EJaxbComplexContent> getCompliantModelClass() {
        return EJaxbComplexContent.class;
    }
    

    @Override
    public ExtensionType getExtensionType() {
        if (!hasExtensionType())
            return null;
        return getXmlContext().getXmlObjectFactory().wrap(getModelObject().getExtension(),
                ExtensionTypeImpl.class);
    }

    @Override
    public RestrictionType getRestrictionType() {
        if (!hasRestrictionType())
            return null;
        return getXmlContext().getXmlObjectFactory().wrap(getModelObject().getRestriction(),
                RestrictionTypeImpl.class);
    }

    @Override
    public boolean hasExtensionType() {
        return getModelObject().getExtension() != null;
    }

    @Override
    public boolean hasRestrictionType() {
        return getModelObject().getRestriction() != null;
    }

    @Override
    public boolean isMixed() {
        return getModelObject().isMixed();
    }

    @Override
    public void setExtensionType(ExtensionType extension) {
        if (extension == null) {
            getModelObject().setExtension(null);
            return;
        }
        getModelObject().setExtension(((ExtensionTypeImpl) extension).getModelObject());
    }

    @Override
    public void setMixed(boolean mixed) {
        getModelObject().setMixed(mixed);
    }

    @Override
    public void setRestrictionType(RestrictionType restrictionType) {
        if (restrictionType == null) {
            getModelObject().setRestriction(null);
            return;
        }
        assert restrictionType instanceof RestrictionTypeImpl;
        getModelObject()
                .setRestriction(
                        JaxbDuplicator.duplicateAs(
                                        (AbstractJaxbModelObject) ((RestrictionTypeImpl) restrictionType)
                                                .getModelObject(),
                                        EJaxbComplexRestrictionType.class));
    }

    
}
