/****************************************************************************
 * Copyright (c) 2009-2012, EBM WebSourcing - All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 *     * Redistributions of source code must retain the above copyright
 *       notice, this list of conditions and the following disclaimer.
 *     * Redistributions in binary form must reproduce the above copyright
 *       notice, this list of conditions and the following disclaimer in the
 *       documentation and/or other materials provided with the distribution.
 *     * Neither the name of the University of California, Berkeley nor the
 *       names of its contributors may be used to endorse or promote products
 *       derived from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE REGENTS AND CONTRIBUTORS ``AS IS'' AND ANY
 * EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
 * WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED. IN NO EVENT SHALL THE REGENTS AND CONTRIBUTORS BE LIABLE FOR ANY
 * DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 * SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 ****************************************************************************/
 
package com.ebmwebsourcing.easyschema10.impl;

import java.util.Arrays;

import com.ebmwebsourcing.easybox.api.XmlContext;
import com.ebmwebsourcing.easybox.api.XmlObject;
import com.ebmwebsourcing.easybox.impl.AbstractJaxbModelObject;
import com.ebmwebsourcing.easybox.impl.JaxbDuplicator;
import com.ebmwebsourcing.easyschema10.api.element.Restriction;
import com.ebmwebsourcing.easyschema10.api.element.Schema;

import easybox.org.w3._2001.xmlschema.EJaxbLocalSimpleType;
import easybox.org.w3._2001.xmlschema.EJaxbRestriction;
import easybox.org.w3._2001.xmlschema.EJaxbSimpleType;
import easybox.org.w3._2001.xmlschema.EJaxbTopLevelSimpleType;

final class SimpleTypeImpl extends AbstractTypeImpl<EJaxbSimpleType> implements
		com.ebmwebsourcing.easyschema10.api.element.SimpleType {

	protected SimpleTypeImpl(XmlContext xmlContext, EJaxbSimpleType jaxbModel) {
		super(xmlContext, jaxbModel);
	}

	@Override
	protected Class<? extends EJaxbSimpleType> getCompliantModelClass() {
		if (getXmlObjectParent() instanceof SchemaImpl) {
			return EJaxbTopLevelSimpleType.class;
		} else {
			return EJaxbLocalSimpleType.class;
		}
	}

	@Override
	public String getName() {
		EJaxbSimpleType simpleType = (EJaxbSimpleType) getModelObject();
		return simpleType.getName();
	}

	@Override
	public boolean hasName() {
		return getModelObject().getName() != null;
	}

	@Override
	public void setName(String name) {
		EJaxbSimpleType simpleType = (EJaxbSimpleType) getModelObject();
		simpleType.setName(name);
	}

	@Override
	public boolean hasFinal() {
		return getModelObject().isSetFinal();
	}

	@Override
	public String[] getFinal() {
		if (!hasFinal())
			return null;
		return getModelObject().getFinal().toArray(
				new String[getModelObject().getFinal().size()]);
	}

	@Override
	public void setFinal(String[] finalStrings) {
		getModelObject().unsetFinal();
		if (finalStrings != null) {
			getModelObject().getFinal().addAll(Arrays.asList(finalStrings));
		}
	}

	@Override
	protected void adaptModelObjectIfNecessary() {
		XmlObject naturalParent = getXmlObjectParent();
		if (naturalParent instanceof Schema) {
			setModelObject(JaxbDuplicator.duplicateAs(getModelObject(),
					EJaxbTopLevelSimpleType.class));
		} else {
			setModelObject(JaxbDuplicator.duplicateAs(getModelObject(),
					EJaxbLocalSimpleType.class));
		}
		super.adaptModelObjectIfNecessary();
	}

	@Override
	public boolean hasRestriction() {
		return getModelObject().getRestriction() != null;
	}

	@Override
	public Restriction getRestriction() {
		if (!hasRestriction())
			return null;
		return getXmlContext().getXmlObjectFactory().wrap(
				getModelObject().getRestriction(), RestrictionImpl.class);
	}

	@Override
	public void setRestriction(Restriction restriction) {
		if (restriction == null) {
			getModelObject().setRestriction(null);
			return;
		}
		assert restriction instanceof RestrictionImpl;
		getModelObject()
				.setRestriction(
						JaxbDuplicator
								.duplicateAs(
										(AbstractJaxbModelObject) ((RestrictionImpl) restriction)
												.getModelObject(),
										EJaxbRestriction.class));
	}

}
