/****************************************************************************
 * Copyright (c) 2009-2012, EBM WebSourcing - All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 *     * Redistributions of source code must retain the above copyright
 *       notice, this list of conditions and the following disclaimer.
 *     * Redistributions in binary form must reproduce the above copyright
 *       notice, this list of conditions and the following disclaimer in the
 *       documentation and/or other materials provided with the distribution.
 *     * Neither the name of the University of California, Berkeley nor the
 *       names of its contributors may be used to endorse or promote products
 *       derived from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE REGENTS AND CONTRIBUTORS ``AS IS'' AND ANY
 * EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
 * WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED. IN NO EVENT SHALL THE REGENTS AND CONTRIBUTORS BE LIABLE FOR ANY
 * DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 * SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 ****************************************************************************/
 
package com.ebmwebsourcing.easyschema10.impl;

import com.ebmwebsourcing.easybox.api.XmlContext;
import com.ebmwebsourcing.easybox.api.XmlObject;

import easybox.org.w3._2001.xmlschema.EJaxbImport;

final class ImportImpl extends AbstractAnnotatedImpl<EJaxbImport> implements
        com.ebmwebsourcing.easyschema10.api.element.Import {

    private XmlObject adoptedSchema;
    
    protected ImportImpl(XmlContext xmlContext, EJaxbImport jaxbModel) {
        super(xmlContext, jaxbModel);
        this.adoptedSchema = null;
    }

    
    
    @Override
    protected Class<? extends EJaxbImport> getCompliantModelClass() {
        return EJaxbImport.class;
    }
    

    @Override
    public String getNamespace() {
        if (!hasNamespace()) {
            return null;
        }
        return getModelObject().getNamespace();
    }

    @Override
    public String getSchemaLocation() {
        if (!hasSchemaLocation()) {
            return null;
        }
        return getModelObject().getSchemaLocation();
    }

    @Override
    public boolean hasNamespace() {
        return getModelObject().getNamespace() != null;
    }

    @Override
    public boolean hasSchemaLocation() {
        return getModelObject().getSchemaLocation() != null;
    }

    @Override
    public void setNamespace(String namespace) {
        getModelObject().setNamespace(namespace);
    }

    @Override
    public void setSchemaLocation(String schemaLocation) {
        getModelObject().setSchemaLocation(schemaLocation);
    }


    @Override
    public final XmlObject[] getXmlObjectAdoptedChildren() {
        if (adoptedSchema == null) { 
            adoptedSchema = adoptChild(getNamespace(), getSchemaLocation(), 0);
        }
        return new XmlObject[] { adoptedSchema };
    }
}
