package org.petalslink.abslayer.service.impl.wsdl11;

import java.util.Map;

import javax.xml.namespace.QName;

import org.petalslink.abslayer.Factory;
import org.petalslink.abslayer.service.api.Binding.BindingStyle;
import org.petalslink.abslayer.service.api.BindingOperationInput;
import org.petalslink.abslayer.service.api.BindingOperationOutput;
import org.petalslink.abslayer.service.api.Input;
import org.petalslink.abslayer.service.api.Operation;
import org.petalslink.abslayer.service.api.Output;

import com.ebmwebsourcing.easybox.api.XmlObject;
import com.ebmwebsourcing.easywsdl11.api.WsdlHelper;
import com.ebmwebsourcing.easywsdl11.api.element.Binding;
import com.ebmwebsourcing.easywsdl11.api.element.BindingOperation;
import com.ebmwebsourcing.easywsdl11.api.element.Definitions;
import com.ebmwebsourcing.easywsdl11.api.element.PortType;

public class BindingOperationImpl implements
        org.petalslink.abslayer.service.api.BindingOperation {

    private final BindingOperation model;
    private BindingOperationInput input;
    private BindingOperationOutput output;


    private BindingOperationImpl(BindingOperation model) {
        this.model = model;
    }

    @Override
    public BindingStyle getStyle() {
        Binding binding = (Binding) model.getXmlObjectParent();
        XmlObject[] soapBindings = binding.getAnyXmlObjects(new QName(
                "http://schemas.xmlsoap.org/wsdl/soap/", "binding"));
        assert soapBindings.length == 1;
        Map<QName, Object> attributes = soapBindings[0]
                .getXmlObjectAttributes();
        String style = (String) attributes.get(new QName("style"));
        assert style != null;
        return "document".equals(style) ? BindingStyle.DOCUMENT
                : BindingStyle.RPC;
    }

    @Override
    public String getName() {
        return model.getName();
    }

	@Override
	public QName inferQName() {
		return new QName(WsdlHelper.findParentDefinitions(this.model).getTargetNamespace(),this.model.getName());
	}

	@Override
	public Operation findOperation() {
		Operation op = null;
		Binding b = (Binding) this.model.getXmlObjectParent();
		PortType p = b.findPortType();
		if(p != null) {
			com.ebmwebsourcing.easywsdl11.api.element.Operation op11 = p.getOperationByName(this.getName());
			if(op11 != null) {
				op = (Operation) Factory.getInstance().wrap(op11);
			}
		}
		return op;
	}

    @Override
    public BindingOperationInput getBindingOperationInput() {
        if (input == null) {
            com.ebmwebsourcing.easywsdl11.api.element.BindingOperationInput inp = model
                    .getInput();
            if (inp != null) {
                input = (org.petalslink.abslayer.service.api.BindingOperationInput) Factory.getInstance().wrap(inp);
            }
        }
        return input;
    }

    @Override
    public BindingOperationOutput getBindingOperationOutput() {
        if (output == null) {
            com.ebmwebsourcing.easywsdl11.api.element.BindingOperationOutput out = model
                    .getOutput();
            if (out != null) {
                output = (org.petalslink.abslayer.service.api.BindingOperationOutput) Factory.getInstance().wrap(out);
            }
        }
        return output;
    }

	@Override
	public org.petalslink.abslayer.service.api.Binding getBinding() {
		return (org.petalslink.abslayer.service.api.Binding) Factory.getInstance().wrap(this.model.getXmlObjectParent());
	}
	
	@Override
	public XmlObject getModel() {
		return this.model;
	}

}
