package org.petalslink.abslayer.service.impl.wsdl11;

import javax.xml.namespace.QName;

import org.petalslink.abslayer.Factory;
import org.petalslink.abslayer.service.api.Description;
import org.petalslink.abslayer.service.api.Query;

import com.ebmwebsourcing.easywsdl11.api.WsdlHelper;

public class PropertyAliasImpl implements
        org.petalslink.abslayer.service.api.PropertyAlias {

    private final com.ebmwebsourcing.easyvprop20.api.anonymoustype.PropertyAlias model;

    private PropertyAliasImpl(com.ebmwebsourcing.easyvprop20.api.anonymoustype.PropertyAlias model) {
        this.model = model;
    }

    @Override
    public QName getQName() {
        return model.getPropertyName();
    }

    @Override
    public QName getElement() {
        return model.getElement();
    }

    @Override
    public QName getMessageType() {
        return model.getMessageType();
    }

    @Override
    public QName getType() {
        return model.getType();
    }

    @Override
    public Query getQuery() {
        return (org.petalslink.abslayer.service.api.Query) Factory.getInstance().wrap(model.getQuery());
    }

    @Override
    public Description getParentDescription() {
        return (Description) WsdlHelper.findParentDefinitions(model).getUserData();
    }

    @Override
    public String getPart() {
        return model.getPart();
    }

}
