package org.petalslink.abslayer;

import java.lang.reflect.Constructor;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

import com.ebmwebsourcing.easybox.api.XmlObject;


public class AbstractFactoryProvider implements FactoryProvider {

    private final Map<Class<?>, Constructor<?>> constructorsFromModelMap; // model class => constructor

    protected AbstractFactoryProvider() {
        this.constructorsFromModelMap = new HashMap<Class<?>, Constructor<?>>();
    }

    @Override
    public Map<Class<?>, Constructor<?>> getConstructorsFromModelMap() {
        return Collections.unmodifiableMap(constructorsFromModelMap);
    }
    
    public final void addModelWrapper(Class<?> modelClass, Class<?> wrapperClass) {
        try {
            Constructor<?> constructor = wrapperClass.getDeclaredConstructors()[0]; //getConstructor(modelClass);
            constructor.setAccessible(true);
            constructorsFromModelMap.put(modelClass, constructor);
        } catch (SecurityException e) {
            // TODO Auto-generated catch block
            e.printStackTrace();
        } 
//        catch (NoSuchMethodException e) {
//            // TODO Auto-generated catch block
//            e.printStackTrace();
//        }
    }

}
