package org.petalslink.abslayer.service.impl.wsdl11;

import javax.xml.namespace.QName;

import org.petalslink.abslayer.Factory;
import org.petalslink.abslayer.service.api.Description;

import com.ebmwebsourcing.easyschema10.api.SchemaHelper;
import com.ebmwebsourcing.easyschema10.api.element.Element;
import com.ebmwebsourcing.easywsdl11.api.element.Definitions;

public class PartImpl implements org.petalslink.abslayer.service.api.Part {

    private final com.ebmwebsourcing.easywsdl11.api.element.Part model;
    private boolean partElementCacheSet = false;
    private com.ebmwebsourcing.easyschema10.api.element.Element partElementCache = null;

    private PartImpl(com.ebmwebsourcing.easywsdl11.api.element.Part model) {
        this.model = model;
    }

    @Override
    public QName getType() {
        return model.getType();
    }

    @Override
    public QName getQName() {
        Definitions definitions = (Definitions) model.getXmlObjectBaseRoot();
        return new QName(definitions.getTargetNamespace(), model.getName());
    }

    
    @Override
    public com.ebmwebsourcing.easyschema10.api.element.Element getElement() {
        if (partElementCache != null) return partElementCache;
        if ((partElementCache == null) && (partElementCacheSet)) return null;
        QName partElement = model.getElement();
        if (partElement == null) return null;
        partElementCache = SchemaHelper.findElementByQName(model.getXmlObjectBaseRoot(), partElement);
        partElementCacheSet = true;
        return partElementCache;
    }

    @Override
    public Element createElement() {
        return model.getXmlContext().getXmlObjectFactory()
                .create(Element.class);
    }

    @Override
    public Description getDescription() {
        return (org.petalslink.abslayer.service.api.Description) Factory.getInstance().wrap(model.getXmlObjectBaseRoot());
    }
}
