/****************************************************************************
 *
 * Copyright (c) 2010-2012, EBM WebSourcing
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA 
 *
 *****************************************************************************/

package org.petalslink.abslayer.service.impl.wsdl11;

import java.util.ArrayList;
import java.util.List;

import javax.xml.namespace.QName;

import org.petalslink.abslayer.Factory;
import org.petalslink.abslayer.service.api.BindingOperation;
import org.petalslink.abslayer.service.api.Description;
import org.petalslink.abslayer.service.api.Interface;

import com.ebmwebsourcing.easybox.api.XmlObject;
import com.ebmwebsourcing.easywsdl11.api.element.Binding;
import com.ebmwebsourcing.easywsdl11.api.element.Definitions;

/**
 * @author Nicolas Salatge - EBM WebSourcing
 */
public class BindingImpl implements org.petalslink.abslayer.service.api.Binding {

    private Binding model;

    private Interface interfac;


    private BindingImpl(Binding model) {
        this.model = model;
    }

    @Override
    public Interface getInterface() {
        if (interfac == null) {
        	interfac = this.getDescription().findInterface(model.getType());
        }
        return interfac;
    }
    
    @Override
    public QName getInterfaceQName() {
        return model.getType();
    }


    @Override
    public BindingOperation getOperationByName(String name) {
        com.ebmwebsourcing.easywsdl11.api.element.BindingOperation bop = model
                .getOperationByName(name);
        if (bop == null)
            return null;
        return (org.petalslink.abslayer.service.api.BindingOperation) Factory.getInstance().wrap(bop);
    }
    
	@Override
	public Description getDescription() {
		Definitions desc = (Definitions) model.getXmlObjectParent();
        if (desc == null)
            return null;
        return (Description) Factory.getInstance().wrap(desc);
	}

	@Override
	public QName getQName() {
		return new QName(this.getDescription().getTargetNamespace(), this.model.getName());
	}

	@Override
	public String toString() {
		return "BindingImpl [model=" + model + "]";
	}

	@Override
	public XmlObject getModel() {
		return this.model;
	}

	@Override
	public BindingOperation[] getOperations() {
		List<BindingOperation> ops = new ArrayList<BindingOperation>();
		com.ebmwebsourcing.easywsdl11.api.element.BindingOperation[] operations = model.getOperations();
		for(com.ebmwebsourcing.easywsdl11.api.element.BindingOperation op: operations) {
			ops.add((org.petalslink.abslayer.service.api.BindingOperation) Factory.getInstance().wrap(op));
		}
		return ops.toArray(new BindingOperation[ops.size()]);
	}

}
