/****************************************************************************
 *
 * Copyright (c) 2010-2012, EBM WebSourcing
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA 
 *
 *****************************************************************************/

package org.petalslink.abslayer.service.impl.wsdl11;

import javax.xml.namespace.QName;

import org.petalslink.abslayer.Factory;
import org.petalslink.abslayer.service.api.Description;
import org.petalslink.abslayer.service.api.Query;

import com.ebmwebsourcing.easywsdl11.api.WsdlHelper;

/**
 * @author Nicolas Salatge - EBM WebSourcing
 */
public class PropertyAliasImpl implements
        org.petalslink.abslayer.service.api.PropertyAlias {

    private final com.ebmwebsourcing.easyvprop20.api.anonymoustype.PropertyAlias model;

    private PropertyAliasImpl(com.ebmwebsourcing.easyvprop20.api.anonymoustype.PropertyAlias model) {
        this.model = model;
    }

    @Override
    public QName getQName() {
        return model.getPropertyName();
    }

    @Override
    public QName getElement() {
        return model.getElement();
    }

    @Override
    public QName getMessageType() {
        return model.getMessageType();
    }

    @Override
    public QName getType() {
        return model.getType();
    }

    @Override
    public Query getQuery() {
        return (org.petalslink.abslayer.service.api.Query) Factory.getInstance().wrap(model.getQuery());
    }

    @Override
    public Description getParentDescription() {
        return (Description) WsdlHelper.findParentDefinitions(model).getUserData();
    }

    @Override
    public String getPart() {
        return model.getPart();
    }
}
