/****************************************************************************
 *
 * Copyright (c) 2010-2012, EBM WebSourcing
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA 
 *
 *****************************************************************************/

package org.petalslink.abslayer.service.impl.wsdl11;

import javax.xml.namespace.QName;

import org.petalslink.abslayer.service.api.Property;

import com.ebmwebsourcing.easywsdl11.api.WsdlHelper;

/**
 * @author Nicolas Salatge - EBM WebSourcing
 */
public class PropertyImpl implements Property {

    private final com.ebmwebsourcing.easyvprop20.api.anonymoustype.Property model;
    private final QName qname;

    private PropertyImpl(com.ebmwebsourcing.easyvprop20.api.anonymoustype.Property model) {
        this.model = model;
        this.qname = new QName(WsdlHelper.findParentDefinitions(model).getTargetNamespace(), 
                model.getName());
    }

    @Override
    public QName getQName() {
        return qname;
    }
}
