/****************************************************************************
 *
 * Copyright (c) 2010-2012, EBM WebSourcing
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA 
 *
 *****************************************************************************/

package org.petalslink.abslayer.service.impl.wsdl11;

import org.petalslink.abslayer.AbstractFactoryProvider;
import org.petalslink.abslayer.service.api.Binding;

/**
 * @author Nicolas Salatge - EBM WebSourcing
 */
public class FactoryProvider extends AbstractFactoryProvider {

    public FactoryProvider() {
        addModelWrapper(com.ebmwebsourcing.easywsdl11.api.element.Binding.class, BindingImpl.class);
        addModelWrapper(com.ebmwebsourcing.easywsdl11.api.element.BindingOperation.class, BindingOperationImpl.class);
        addModelWrapper(com.ebmwebsourcing.easywsdl11.api.element.BindingOperationInput.class, BindingOperationInputImpl.class);
        addModelWrapper(com.ebmwebsourcing.easywsdl11.api.element.BindingOperationOutput.class, BindingOperationOutputImpl.class);
        addModelWrapper(com.ebmwebsourcing.easywsdl11.api.element.Definitions.class, DescriptionImpl.class);
        addModelWrapper(com.ebmwebsourcing.easywsdl11.api.element.Port.class, EndpointImpl.class);
        addModelWrapper(com.ebmwebsourcing.easywsdl11.api.element.Fault.class, FaultImpl.class);
		addModelWrapper(com.ebmwebsourcing.easywsdl11.api.element.Import.class, ImportImpl.class);
        addModelWrapper(com.ebmwebsourcing.easywsdl11.api.element.Input.class, InputImpl.class);
        addModelWrapper(com.ebmwebsourcing.easywsdl11.api.element.PortType.class, InterfaceImpl.class);
        addModelWrapper(com.ebmwebsourcing.easywsdl11.api.element.Message.class, MessageImpl.class);
        addModelWrapper(com.ebmwebsourcing.easywsdl11.api.element.Operation.class, OperationImpl.class);
        addModelWrapper(com.ebmwebsourcing.easywsdl11.api.element.Output.class, OutputImpl.class);
        addModelWrapper(com.ebmwebsourcing.easywsdl11.api.element.Part.class, PartImpl.class);
        addModelWrapper(com.ebmwebsourcing.easyplnk20.api.element.PartnerLinkType.class, PartnerLinkTypeImpl.class);
        addModelWrapper(com.ebmwebsourcing.easyvprop20.api.anonymoustype.PropertyAlias.class, PropertyAliasImpl.class);
        addModelWrapper(com.ebmwebsourcing.easyvprop20.api.anonymoustype.Property.class, PropertyImpl.class);
        addModelWrapper(com.ebmwebsourcing.easyvprop20.api.element.Query.class, QueryImpl.class);
        addModelWrapper(com.ebmwebsourcing.easyplnk20.api.element.Role.class, RoleImpl.class);
        addModelWrapper(com.ebmwebsourcing.easywsdl11.api.element.Service.class, ServiceImpl.class);
        addModelWrapper(com.ebmwebsourcing.easywsdl11.api.element.Types.class, TypesImpl.class);   
    }
}
