/****************************************************************************
 *
 * Copyright (c) 2010-2012, EBM WebSourcing
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA 
 *
 *****************************************************************************/

package org.petalslink.abslayer.service.impl.wsdl11;

import javax.xml.namespace.QName;

import org.petalslink.abslayer.Factory;
import org.petalslink.abslayer.service.api.Part;

import com.ebmwebsourcing.easywsdl11.api.element.Message;

/**
 * @author Nicolas Salatge - EBM WebSourcing
 */
public class OutputImpl implements org.petalslink.abslayer.service.api.Output {

    private final com.ebmwebsourcing.easywsdl11.api.element.Output model;
    
    private Part[] parts;

    private OutputImpl(com.ebmwebsourcing.easywsdl11.api.element.Output model) {
        this.model = model;
    }

    @Override
    public QName getMessageName() {
        return model.getMessage();
    }
    
    @Override
    public Part[] getParts() {
        // TODO: urk should not access parts from here; should not access parts
        // at all (wsdl11 specific).
        if (parts == null) {
            Message message = model.findMessage();
            assert message != null;
            com.ebmwebsourcing.easywsdl11.api.element.Part[] messageParts = message
                    .getParts();
            parts = new Part[messageParts.length];
            int i = 0;
            for (com.ebmwebsourcing.easywsdl11.api.element.Part part : messageParts) {
                parts[i] = (org.petalslink.abslayer.service.api.Part) Factory.getInstance().wrap(part);
            }
        }
        return parts;
    }
    
    @Override
    public com.ebmwebsourcing.easyschema10.api.element.Element getElement() {
        Part[] parts = getParts();
        if (parts.length > 0)
            return parts[0].getElement();
        return null;
    }
}
