/****************************************************************************
 *
 * Copyright (c) 2010-2012, EBM WebSourcing
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA 
 *
 *****************************************************************************/

package org.petalslink.abslayer.service.impl.wsdl11;

import javax.xml.namespace.QName;

import org.petalslink.abslayer.Factory;
import org.petalslink.abslayer.service.api.Part;

/**
 * @author Nicolas Salatge - EBM WebSourcing
 */
public class MessageImpl implements org.petalslink.abslayer.service.api.Message {

    private final com.ebmwebsourcing.easywsdl11.api.element.Message model;

    private Part[] parts;

    private MessageImpl(com.ebmwebsourcing.easywsdl11.api.element.Message model) {
        this.model = model;
    }

    @Override
    public Part getPart(QName qname) {
        com.ebmwebsourcing.easywsdl11.api.element.Part p = model
                .getPartByName(qname.getLocalPart());
        if (p == null)
            return null;
        return (org.petalslink.abslayer.service.api.Part) Factory.getInstance().wrap(p);
    }

    @Override
    public Part[] getParts() {
        // TODO: urk should not access parts from here; should not access
        // message at all (wsdl11 specific).
        if (parts == null) {
            com.ebmwebsourcing.easywsdl11.api.element.Part[] messageParts = model
                    .getParts();
            parts = new Part[messageParts.length];
            int i = 0;
            for (com.ebmwebsourcing.easywsdl11.api.element.Part part : messageParts) {
                parts[i] = (org.petalslink.abslayer.service.api.Part) Factory.getInstance().wrap(part);
            }
        }
        return parts;
    }
}
