/****************************************************************************
 *
 * Copyright (c) 2010-2012, EBM WebSourcing
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA 
 *
 *****************************************************************************/

package org.petalslink.abslayer;

import java.net.URI;
import java.net.URISyntaxException;

/**
 * Constants for WSDL version.
 * @author Nicolas Salatge - EBM WebSourcing
 */
public enum WSDLVersionConstants {

    WSDL11(Constants.WSDL_11_NAMESPACE), WSDL20(Constants.WSDL_20_NAMESPACE);

    /**
     * @param pattern
     * @return
     */
    public static WSDLVersionConstants valueOf(final URI pattern) {
        WSDLVersionConstants result = null;
        if (pattern != null) {
            for (final WSDLVersionConstants version : WSDLVersionConstants
                    .values()) {
                if (version.nameSpace.equals(pattern.toString())) {
                    result = version;
                }
            }
        }
        return result;
    }

    private final String nameSpace;

    private final URI version;

    /**
     * Creates a new instance of {@link WSDLVersionConstants}
     * 
     * @param nameSpace
     */
    private WSDLVersionConstants(final String nameSpace) {
        this.nameSpace = nameSpace;
        if (this.nameSpace != null) {
            try {
                this.version = new URI(nameSpace);
            } catch (final URISyntaxException e) {
                throw new Error("Unexpected Error in URI namespace syntax", e);
            }
        } else {
            this.version = null;
        }
    }

    /**
     * @return
     */
    public URI value() {
        return this.version;
    }

    /**
     * Please use this equals method instead of using :<code>
     * value().equals(mep)
     * </code> which is almost 10 times slower...
     * 
     * @param mep
     * @return
     */
    public boolean equals(final URI version) {
        return this.toString().equals(version.toString());
    }

    /*
     * (non-Javadoc)
     * 
     * @see java.lang.Enum#toString()
     */
    @Override
    public String toString() {
        return this.nameSpace;
    }

}