/****************************************************************************
 *
 * Copyright (c) 2010-2012, EBM WebSourcing
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA 
 *
 *****************************************************************************/

package org.petalslink.abslayer.service.api;

import java.net.URI;
import java.util.Collection;
import java.util.List;
import java.util.Map;

import javax.xml.namespace.QName;

import org.w3c.dom.Document;

import com.ebmwebsourcing.easybox.api.XmlObject;
import com.ebmwebsourcing.easybox.api.XmlObjectWriteException;
import com.ebmwebsourcing.easyschema10.api.element.Element;
import com.ebmwebsourcing.easyschema10.api.element.Schema;

/**
 * @author Nicolas Salatge - EBM WebSourcing
 */
public interface Description {
    
    public Message findMessage(QName qname);
    
    public Map<String, String> getNamespaces();
    
    public URI getDocumentBaseURI();
    
    public String getTargetNamespace();
    
    public Types getTypes();
    
    public org.petalslink.abslayer.service.api.PartnerLinkType getPartnerLinkType(QName qname);
    
    public Interface findInterface(final QName name);

    public Service findService(final QName name);
    
    public Binding findBinding(final QName name);
    
    public List<Interface> getInterfaces();

    public List<Endpoint> findEndpointsImplementingInterface(
            Interface itf);
    
    public List<Service> findServicesImplementingInterface(
            Interface itf);

    public XmlObject getModel();

    public Endpoint findEndpoint(String endpointName);

    public Collection<? extends Binding> getBindings();

    public Collection<? extends Element> findElementsInAllSchema(QName element);

    public Property findProperty(QName qname);

    public Collection<? extends PropertyAlias> getPropertyAliases();
    
    public Collection<? extends PropertyAlias> getPropertyAliases4ThisProperty(
            QName propName);

	public Collection<? extends Service> getServices();
	
	public Collection<? extends Import> getImports();
	
	public Document write() throws XmlObjectWriteException;

	public BindingOperation findBindingOperation(QName qname);	
}
