/****************************************************************************
 *
 * Copyright (c) 2009-2012, EBM WebSourcing
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA 
 *
 *****************************************************************************/
 
package com.ebmwebsourcing.easyviper.core.api.engine.behaviour;

import java.util.List;

import org.oasisopen.sca.annotation.PolicySets;
import org.oasisopen.sca.annotation.Reference;
import org.oasisopen.sca.annotation.Scope;
import org.oasisopen.sca.annotation.Service;

import com.ebmwebsourcing.easycommons.sca.helper.impl.SCAComponentImpl;
import com.ebmwebsourcing.easyviper.core.api.CoreException;
import com.ebmwebsourcing.easyviper.core.api.engine.Execution;
import com.ebmwebsourcing.easyviper.core.api.engine.Node;

/**
 * @author Nicolas Salatge - EBM WebSourcing
 */
@Scope("COMPOSITE")
@Service(value = Behaviour.class, names = "abstract_service")
@PolicySets("frascati:scaEasyPrimitive")
public abstract class AbstractBehaviourImpl extends SCAComponentImpl implements Behaviour {

    @Reference(name = "node", required = false)
    private Node node;

    protected Node nextTarget;
    protected Execution currentExecution;
    
    protected void selectNextNodeToExecute(Execution execution, Node nextTarget) throws CoreException {
        List<Node> out = getNode().getOutgoingNodes();

        if(nextTarget != null) {
        	this.nextTarget = nextTarget;
        } else if (out.size() == 1) {
        	this.nextTarget = out.get(0);
        } else if ((getNode().getParentNode() != null)
                && (getNode().getParentNode().getBehaviour().isActiveIn(execution))) {
        	this.nextTarget = getNode().getParentNode();
        } else if ((getNode().getScope() != null) && (getNode().getScope().getBehaviour().isActiveIn(execution))) {
        	this.nextTarget = getNode().getScope();
        } else {
        	this.nextTarget = null;
        }
    }
    
        
    @Override
    public final Node notifyParentBehaviour(Execution execution, Node nextNodeToExecute) throws CoreException {
        if (getNode().getParentNode() != null && getNode().getParentNode().getBehaviour() != null) {
            return getNode().getParentNode().getBehaviour().onChildBehaviourNotification(execution, nextNodeToExecute, this);
        }
        return null;
    }

    @Override
    public Node onChildBehaviourNotification(Execution execution, Node nextNodeToExecute, Behaviour childBehaviour)
            throws CoreException {
        // by default, when a child behaviour notifies, do nothing
    	return null;
    }

    public Node getNode() {
        return this.node;
    }

    @Override
    public final String toString() {
        return "behaviour " + this.getName() + " on Node " + this.getNode().getName();
    }

    public boolean isActiveIn(Execution execution) {
        return this.currentExecution == execution;
    } 
    
    public void setCurrentExecution(Execution execution) {
    	this.currentExecution = execution;
    }
}
