/****************************************************************************
 *
 * Copyright (c) 2009-2012, EBM WebSourcing
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA 
 *
 *****************************************************************************/
 
package com.ebmwebsourcing.easyviper.core.api.engine;

import java.util.List;
import java.util.Map;

import com.ebmwebsourcing.easyviper.core.api.CoreException;
import com.ebmwebsourcing.easyviper.core.api.engine.behaviour.Behaviour;
import com.ebmwebsourcing.easyviper.core.api.engine.fault.Fault;
import com.ebmwebsourcing.easyviper.core.api.engine.handler.TerminationHandler;
import com.ebmwebsourcing.easyviper.core.api.engine.variable.Variable;
import com.ebmwebsourcing.easyviper.core.api.soa.Partner;
import com.ebmwebsourcing.easyviper.core.api.soa.correlation.CorrelationGroup;

/**
 * @author Nicolas Salatge - EBM WebSourcing
 */
//@Interface(name = "scope")
public interface Scope extends Node {

	Node createNode(String behaviourName, Class<? extends Behaviour> behaviourContextClass, Map<String, Object> context)
			throws CoreException;

	boolean removeNode(Node node) throws CoreException;

	void end(boolean clean) throws CoreException;

	void linkedBrotherNodes(Node sourceNode, Node targetNode) throws CoreException;
	
    void linkedChildNodeToParent(Node parentNode, Node childNode)
            throws CoreException;

    void linkedChildNodeToParent2(Node parentNode, Node childNode)
            throws CoreException;

	Node unlinkBrotherNodes(final Node sourceNode, final Node targetNode) throws CoreException;
	
	void linkedExecutableElement2Execution(Node source,
			Execution exe) throws CoreException;
	
	void linkedNodeAndFunctionnalBehaviour(Node node, Behaviour behaviour) throws CoreException;
	
	void unlinkedNodeAndFunctionnalBehaviour(Node node, Behaviour behaviour) throws CoreException;	


	List<Node> getAllNodes() throws CoreException;
	
	List<Scope> getAllScopes() throws CoreException;

	Node getNodeByName(String name) throws CoreException;

	Node getInitialNode() throws CoreException;

	void setInitialNode(Node initial) throws CoreException;

	Map<String, Variable> getVariables();
	
	/**
	 * Get all variables known from this scope,
	 * ie declared in this scope itself or in parent scopes.
	 * 
	 * @return
	 */
	Map<String, Variable> getInScopeVariables() throws CoreException;
	
    void getInScopeVariables(Map<String, Variable> result) throws CoreException;
	
	Map<String, Partner> getPartners();
	
	List<CorrelationGroup> getCorrelationGroups();

	Variable findVariable(String name) throws CoreException;
	
	<B extends Behaviour> List<B> findBehaviours(Class<B> behaviourClass) throws CoreException;
	
	/*
	 * TODO something has been changed here : the semantic of the boolean must be explained
	 */
	<B extends Behaviour> List<B> findBehaviours(Class<B> behaviourClass, boolean ignoreIfComponentIsStopped) throws CoreException;
	
	Partner findPartner(final String partnerName) throws CoreException;
	
	List<CorrelationGroup> findCorrelationGroups(String name) throws CoreException;

	void setVariable(Variable v) throws CoreException;

	Scope getParentScope() throws CoreException;

	Map<Fault, Scope> getExceptions();
	
	void addException(Fault fault, Scope faultScope);
	
	Exception getException();
	
	void setException(Exception fault);
	
	void setTerminationHandler(TerminationHandler th);
	
	TerminationHandler getTerminationHandler();
	
    ExpressionEvaluator getExpressionEvaluator();
    
    void setExpressionEvaluator(ExpressionEvaluator expressionEvaluator);
    
    PartnerEvaluator getPartnerEvaluator();
    
    void setPartnerEvaluator(PartnerEvaluator partnerEvaluator);
    
    
}
