/****************************************************************************
 *
 * Copyright (c) 2009-2012, EBM WebSourcing
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA 
 *
 *****************************************************************************/
 
package com.ebmwebsourcing.easyviper.core.api.engine.behaviour;

import java.util.logging.Logger;

import org.oasisopen.sca.annotation.PolicySets;
import org.oasisopen.sca.annotation.Scope;
import org.oasisopen.sca.annotation.Service;

import com.ebmwebsourcing.easyviper.core.api.CoreException;
import com.ebmwebsourcing.easyviper.core.api.engine.Execution;
import com.ebmwebsourcing.easyviper.core.api.engine.Node;

/**
 * @author Nicolas Salatge - EBM WebSourcing
 */
@Scope("COMPOSITE")
@Service(value=Behaviour.class,names="abstract_service")
@PolicySets("frascati:scaEasyPrimitive")
public abstract class AbstractSimpleBehaviourImpl extends AbstractBehaviourImpl {

    protected Logger log = Logger.getLogger(AbstractSimpleBehaviourImpl.class.getSimpleName());
	protected abstract void doExecute(Execution execution);

	
	@Override
    public Node execute(Execution execution) throws CoreException {
	    currentExecution = execution;
	    assert execution != null;
	    nextTarget = null;
	    this.state = State.ACTIVITY_STARTED;
        this.log.fine(
                String.format("executing '%s' behaviour on node '%s'", 
                        getName(), 
                        getNode().getName()));

        
            doExecute(execution);
            selectNextNodeToExecute(execution, null);

        this.log.fine(
                String.format("executed '%s' behaviour on node '%s'", 
                        getName(), 
                        getNode().getName()));
        currentExecution = null;
        this.state = State.ACTIVITY_ENDED;
        return nextTarget;        
	}
	
	
	@Override
	public void reset() {
	    // nothing to do because no internal state.
	}	
}
