/*
 * Decompiled with CFR 0.152.
 */
package com.ebmwebsourcing.easyviper.core.api.engine.behaviour;

import com.ebmwebsourcing.easycommons.sca.helper.api.SCAException;
import com.ebmwebsourcing.easycommons.sca.helper.impl.SCAHelper;
import com.ebmwebsourcing.easyviper.core.api.CoreException;
import com.ebmwebsourcing.easyviper.core.api.engine.Execution;
import com.ebmwebsourcing.easyviper.core.api.engine.Node;
import com.ebmwebsourcing.easyviper.core.api.engine.behaviour.AbstractBehaviourImpl;
import com.ebmwebsourcing.easyviper.core.api.engine.behaviour.Behaviour;
import java.util.List;
import java.util.logging.Logger;
import org.oasisopen.sca.ServiceReference;
import org.oasisopen.sca.annotation.PolicySets;
import org.oasisopen.sca.annotation.Scope;
import org.oasisopen.sca.annotation.Service;
import org.objectweb.fractal.api.Component;

@Scope(value="COMPOSITE")
@Service(value={Behaviour.class}, names={"abstract_service"})
@PolicySets(value={"frascati:scaEasyPrimitive"})
public abstract class AbstractComplexBehaviourImpl
extends AbstractBehaviourImpl {
    protected Logger log = Logger.getLogger(AbstractComplexBehaviourImpl.class.getSimpleName());

    protected Behaviour.State executeOnInactive(Execution execution) {
        this.selectNextNodeToExecute(execution, this.getNode());
        return Behaviour.State.ACTIVITY_STARTED;
    }

    protected Behaviour.State executeOnStarted(Execution execution) {
        this.selectNextNodeToExecute(execution, this.getNode());
        return Behaviour.State.ACTIVITY_ENDED;
    }

    protected Behaviour.State executeOnEnded(Execution execution) {
        this.selectNextNodeToExecute(execution, null);
        return Behaviour.State.ACTIVITY_ENDED;
    }

    @Override
    public final Node execute(Execution execution) throws CoreException {
        assert (execution != null);
        this.currentExecution = execution;
        this.log.fine(String.format("executing '%s' behaviour on node '%s' (state = '%s')...", this.getName(), this.getNode().getName(), String.valueOf((Object)this.state)));
        this.nextTarget = null;
        if (this.state == Behaviour.State.ACTIVITY_INACTIVE) {
            this.state = this.executeOnInactive(execution);
        } else if (this.state == Behaviour.State.ACTIVITY_STARTED) {
            this.state = this.executeOnStarted(execution);
        } else if (this.state == Behaviour.State.ACTIVITY_ENDED) {
            this.state = this.executeOnEnded(execution);
            this.currentExecution = null;
        }
        this.log.fine(String.format("executed '%s' behaviour on node '%s' (state = '%s')...", this.getName(), this.getNode().getName(), String.valueOf((Object)this.state)));
        if (this.nextTarget == null) {
            this.selectNextNodeToExecute(execution, null);
        }
        return this.nextTarget;
    }

    @Override
    public void reset() {
        this.state = Behaviour.State.ACTIVITY_INACTIVE;
        List<Node> childNodes = this.getNode().getChildNodes();
        for (Node childNode : childNodes) {
            try {
                Component targetComp = SCAHelper.getSCAHelper().getComponentByInterface(SCAHelper.getSCAHelper().getParent(this.getComponent()), (ServiceReference)childNode, "service");
                if (!SCAHelper.getSCAHelper().isStarted(targetComp)) continue;
                childNode.getBehaviour().reset();
            }
            catch (SCAException e) {
                throw new CoreException(e);
            }
        }
    }
}

