/*******************************************************************************
 * Copyright (c) 2011 EBM Websourcing.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the GNU Lesser Public License v2.1
 * which accompanies this distribution, and is available at
 * http://www.gnu.org/licenses/old-licenses/gpl-2.0.html
 * 
 * Contributors:
 *     EBM Websourcing - initial API and implementation
 ******************************************************************************/
package com.ebmwebsourcing.easyviper.tools;

public final class InstanceOfUtil {

	public static <C> boolean isClassExtendOfClass2found(Class<?> c, Class<? extends C> class2found) {
		boolean res = false;
		try {
			if(c != null) {
				if(c.getName().equals(class2found.getName())) {
					res = true;
				} else if(c.getInterfaces() != null) {
					for(Class<?> subc : c.getInterfaces()) {
						res = isClassExtendOfClass2found(subc, class2found);
						if(res == true) {
							break;
						}
					}
				}
			}
		} catch(ClassCastException e) {

		}
		return res;
	}
	
}
