/*
 * Decompiled with CFR 0.152.
 */
package com.ebmwebsourcing.easyviper.core.impl.engine;

import com.ebmwebsourcing.easycommons.sca.helper.api.SCAException;
import com.ebmwebsourcing.easycommons.sca.helper.impl.Binding;
import com.ebmwebsourcing.easycommons.sca.helper.impl.SCAHelper;
import com.ebmwebsourcing.easyviper.core.api.CoreException;
import com.ebmwebsourcing.easyviper.core.api.engine.Execution;
import com.ebmwebsourcing.easyviper.core.api.engine.Node;
import com.ebmwebsourcing.easyviper.core.api.engine.Process;
import com.ebmwebsourcing.easyviper.core.api.engine.Scope;
import com.ebmwebsourcing.easyviper.core.api.engine.behaviour.Behaviour;
import com.ebmwebsourcing.easyviper.core.api.engine.fault.Fault;
import com.ebmwebsourcing.easyviper.core.api.engine.handler.TerminationHandler;
import com.ebmwebsourcing.easyviper.core.api.engine.variable.Variable;
import com.ebmwebsourcing.easyviper.core.api.soa.Endpoint;
import com.ebmwebsourcing.easyviper.core.api.soa.correlation.CorrelationGroup;
import com.ebmwebsourcing.easyviper.core.impl.engine.ExecutionImpl;
import com.ebmwebsourcing.easyviper.core.impl.engine.NodeImpl;
import com.ebmwebsourcing.easyviper.tools.InstanceOfUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import javax.xml.namespace.QName;
import org.oasisopen.sca.ServiceReference;
import org.oasisopen.sca.annotation.PolicySets;
import org.oasisopen.sca.annotation.Service;
import org.objectweb.fractal.api.Component;
import org.objectweb.fractal.api.Interface;
import org.objectweb.fractal.api.NoSuchInterfaceException;
import org.osoa.sca.annotations.Property;
import org.ow2.frascati.tinfi.api.control.ContentInstantiationException;
import org.ow2.frascati.tinfi.api.control.SCAContentController;

@org.oasisopen.sca.annotation.Scope(value="COMPOSITE")
@Service(value={Scope.class}, names={"service"})
@PolicySets(value={"frascati:scaEasyCompositeWithContent"})
public class ScopeImpl
extends NodeImpl
implements Scope {
    private static final long serialVersionUID = 1L;
    private static int cpt_childsNode = 0;
    private static int cpt_incomingNode = 0;
    private static int cpt_outgoingNode = 0;
    private static Logger log = Logger.getLogger(ScopeImpl.class.getName());
    protected Component initialNode;
    protected Component parentExecution;
    @Property(name="exceptions", required=false)
    protected Map<Fault, Scope> exceptions = new HashMap<Fault, Scope>();
    @Property(name="endpoints", required=false)
    protected Map<Object, Endpoint> endpoints = new HashMap<Object, Endpoint>();
    @Property(name="correlationGroups", required=false)
    protected List<CorrelationGroup> correlationGroups = new ArrayList<CorrelationGroup>();
    @Property(name="faultScope", required=false)
    protected Exception faultScope = null;
    @Property(name="terminationHandler", required=false)
    protected TerminationHandler terminationHandler = null;
    @Property(name="variables", required=true)
    private final Map<QName, Variable> variables = new HashMap<QName, Variable>();

    public Node createNode(String behaviourName, Class<? extends Behaviour> behaviourContextClass, Map<String, Object> context) throws CoreException {
        log.finest("start create node");
        Node node = null;
        String nodeName = null;
        try {
            if (behaviourName == null) {
                behaviourName = behaviourContextClass.getSimpleName();
                nodeName = "node_supporting_" + behaviourName + "_" + this.getAllNodes().size();
            } else {
                nodeName = "node_supporting_" + behaviourName;
            }
            Component fractalNode = SCAHelper.getSCAHelper().createNewComponent(NodeImpl.class.getName(), null);
            SCAHelper.getSCAHelper().addComponent(fractalNode, this.getComponent(), null);
            SCAContentController scacc = (SCAContentController)fractalNode.getFcInterface("/sca-content-controller");
            try {
                node = (Node)scacc.getFcContent();
            }
            catch (ContentInstantiationException e) {
                throw new CoreException((Throwable)e);
            }
            node.setName(nodeName);
            if (!log.getName().equals(ScopeImpl.class.getName())) {
                node.setLog(log);
            }
            node = (Node)fractalNode.getFcInterface("service");
            Component fractalBehaviour = SCAHelper.getSCAHelper().createNewComponent(behaviourContextClass.getName(), context);
            SCAHelper.getSCAHelper().changeName(fractalBehaviour, behaviourName);
            SCAHelper.getSCAHelper().addComponent(fractalBehaviour, this.getComponent(), null);
            Behaviour behaviour = null;
            scacc = (SCAContentController)fractalBehaviour.getFcInterface("/sca-content-controller");
            try {
                behaviour = (Behaviour)scacc.getFcContent();
            }
            catch (ContentInstantiationException e) {
                throw new CoreException((Throwable)e);
            }
            if (!log.getName().equals(ScopeImpl.class.getName())) {
                behaviour.setLog(log);
            }
            behaviour = (Behaviour)fractalBehaviour.getFcInterface("service");
            this.linkedNodeAndFunctionnalBehaviour(node, behaviour);
            log.fine("Creation of the fractal node: " + behaviourName);
        }
        catch (NoSuchInterfaceException e) {
            log.severe(e.getMessage());
            throw new CoreException((Throwable)e);
        }
        catch (SCAException e) {
            log.severe(e.getMessage());
            throw new CoreException((Throwable)e);
        }
        log.finest("end of create node");
        return node;
    }

    public Node getInitialNode() throws CoreException {
        Node res = null;
        try {
            if (this.initialNode != null) {
                res = (Node)this.initialNode.getFcInterface("service");
            }
        }
        catch (NoSuchInterfaceException e) {
            throw new CoreException((Throwable)e);
        }
        return res;
    }

    public Node getNode(String name) throws CoreException {
        Node res = null;
        try {
            List comps = SCAHelper.getSCAHelper().getComponentsByName(this.getComponent(), name);
            ArrayList<Node> nodes = new ArrayList<Node>();
            if (comps != null) {
                for (Component comp : comps) {
                    if (!(comp.getFcInterface("service") instanceof Node)) continue;
                    nodes.add((Node)comp.getFcInterface("service"));
                }
            }
            if (nodes.size() > 1) {
                throw new CoreException("Several node components are the same name");
            }
            if (nodes.size() > 0) {
                res = (Node)nodes.get(0);
            }
        }
        catch (NoSuchInterfaceException e) {
            throw new CoreException((Throwable)e);
        }
        catch (SCAException e) {
            throw new CoreException((Throwable)e);
        }
        return res;
    }

    public void deleteExecution(Execution exec) throws CoreException {
        ArrayList<Binding> listOfBindings = new ArrayList<Binding>();
        try {
            listOfBindings.add(new Binding("service", (Interface)exec.getComponent().getFcInterface("service")));
            SCAHelper.getSCAHelper().deleteBindings(this.getComponent(), listOfBindings);
            SCAHelper.getSCAHelper().deleteComponent(exec.getComponent());
        }
        catch (NoSuchInterfaceException e) {
            throw new CoreException("impossible to delete binding", (Throwable)e);
        }
        catch (SCAException e) {
            throw new CoreException("impossible to delete binding", (Throwable)e);
        }
    }

    public void stopAllExecutions() throws CoreException {
        try {
            for (Execution execution : this.getParentExecution().getChildExecutions()) {
                execution.stopSCAComponent();
            }
            this.getParentExecution().stopSCAComponent();
        }
        catch (SCAException e) {
            throw new CoreException((Throwable)e);
        }
    }

    public void startAllExecutions() throws CoreException {
        try {
            for (Execution execution : this.getParentExecution().getChildExecutions()) {
                execution.startSCAComponent();
            }
            this.getParentExecution().startSCAComponent();
        }
        catch (SCAException e) {
            throw new CoreException((Throwable)e);
        }
    }

    public void end(boolean clean) throws CoreException {
        try {
            if (this.terminationHandler != null) {
                this.terminationHandler.end((Scope)this);
            }
            if (clean) {
                log.finest("clean all scopes");
                this.cleanScopes(this);
                log.finest("stop all sub components");
                SCAHelper.getSCAHelper().stopAllSubComponents(this.getComponent());
            }
        }
        catch (SCAException e) {
            throw new CoreException((Throwable)e);
        }
    }

    protected void cleanScopes(Scope scope) throws CoreException {
        for (Scope faultScope : scope.getExceptions().values()) {
            this.cleanScopes(faultScope);
        }
        scope.setFaultScope(null);
        this.cleanVariables(scope);
        this.setBehavioursState(scope, Behaviour.State.ACTIVITY_ENDED);
        try {
            log.finest("remove all executions");
            if (scope.getParentExecution() != null) {
                scope.getParentExecution().removeChildExecutions();
                Component exeComp = SCAHelper.getSCAHelper().getComponentByInterface(scope.getComponent(), (Interface)scope.getParentExecution(), "service");
                if (exeComp != null) {
                    SCAHelper.getSCAHelper().deleteComponent(exeComp);
                }
            }
            scope.setParentExecution(null);
            List components = SCAHelper.getSCAHelper().getComponents(scope.getComponent());
            for (Component component : components) {
                if (!SCAHelper.getSCAHelper().isStarted(component)) continue;
                try {
                    if (!(component.getFcInterface("service") instanceof Scope)) continue;
                    Scope underScope = (Scope)component.getFcInterface("service");
                    this.cleanScopes(underScope);
                }
                catch (NoSuchInterfaceException noSuchInterfaceException) {
                    // empty catch block
                }
            }
        }
        catch (CoreException e) {
            throw new CoreException((Throwable)e);
        }
        catch (SCAException e) {
            throw new CoreException((Throwable)e);
        }
    }

    public void setBehavioursState(Scope scope, Behaviour.State state) throws CoreException {
        try {
            List components = SCAHelper.getSCAHelper().getComponents(scope.getComponent());
            for (Component component : components) {
                if (!SCAHelper.getSCAHelper().isStarted(component)) continue;
                try {
                    Behaviour behaviour = (Behaviour)component.getFcInterface("service");
                    behaviour.setState(state);
                }
                catch (NoSuchInterfaceException noSuchInterfaceException) {
                }
                catch (ClassCastException classCastException) {
                    // empty catch block
                }
            }
        }
        catch (SCAException e) {
            throw new CoreException((Throwable)e);
        }
    }

    private void cleanVariables(Scope scope) throws CoreException {
        log.finest("Clean all variables of scope: " + scope.getName());
        for (Variable var : scope.getVariables().values()) {
            var.setValue(null);
        }
    }

    public boolean removeNode(Node node) throws CoreException {
        boolean res = true;
        try {
            Component nodeComp = SCAHelper.getSCAHelper().getComponentByInterface(this.getComponent(), (Interface)node, "service");
            Node child = null;
            String clientItfName = "childNodes_";
            Map map = SCAHelper.getSCAHelper().getServerInterfacesLinkedToClientInterfacesOfComponent(nodeComp);
            Iterator entries = map.entrySet().iterator();
            Map.Entry entry = null;
            while (entries != null && entries.hasNext()) {
                entry = entries.next();
                if (!((String)entry.getKey()).startsWith("childNodes_")) continue;
                child = (Node)entry.getValue();
                this.removeNode(child);
                map = SCAHelper.getSCAHelper().getServerInterfacesLinkedToClientInterfacesOfComponent(nodeComp);
                entries = map.entrySet().iterator();
            }
            SCAHelper.getSCAHelper().deleteComponent(nodeComp);
        }
        catch (SCAException e) {
            throw new CoreException((Throwable)e);
        }
        return true;
    }

    public void setInitialNode(Node initial) throws CoreException {
        try {
            this.initialNode = SCAHelper.getSCAHelper().getComponentByInterface(this.getComponent(), (Interface)initial, "service");
        }
        catch (SCAException e) {
            throw new CoreException((Throwable)e);
        }
    }

    public Execution getParentExecution() throws CoreException {
        Execution res = null;
        try {
            if (this.parentExecution != null) {
                res = (Execution)this.parentExecution.getFcInterface("service");
            }
        }
        catch (NoSuchInterfaceException e) {
            throw new CoreException((Throwable)e);
        }
        return res;
    }

    public List<Node> getAllNodes() throws CoreException {
        ArrayList<Node> nodes = new ArrayList<Node>();
        try {
            List comps = SCAHelper.getSCAHelper().getComponents(this.getComponent());
            for (Component component : comps) {
                try {
                    if (!(component.getFcInterface("service") instanceof Node)) continue;
                    nodes.add((Node)component.getFcInterface("service"));
                }
                catch (NoSuchInterfaceException noSuchInterfaceException) {
                    // empty catch block
                }
            }
        }
        catch (SCAException e) {
            throw new CoreException((Throwable)e);
        }
        return nodes;
    }

    public List<Scope> getAllScopes() throws CoreException {
        ArrayList<Scope> scope = new ArrayList<Scope>();
        try {
            scope.add(this);
            List comps = SCAHelper.getSCAHelper().getAllSubComponents(this.getComponent());
            for (Component component : comps) {
                try {
                    if (!(component.getFcInterface("service") instanceof Scope)) continue;
                    scope.add((Scope)component.getFcInterface("service"));
                }
                catch (NoSuchInterfaceException noSuchInterfaceException) {
                    // empty catch block
                }
            }
        }
        catch (SCAException e) {
            throw new CoreException((Throwable)e);
        }
        return scope;
    }

    public Node getNodeByName(String name) throws CoreException {
        Node res = null;
        try {
            List comps = SCAHelper.getSCAHelper().getComponentsByName(this.getComponent(), name);
            ArrayList<Node> nodes = new ArrayList<Node>();
            if (comps != null) {
                for (Component comp : comps) {
                    if (!(comp.getFcInterface("service") instanceof Node)) continue;
                    nodes.add((Node)comp.getFcInterface("service"));
                }
            }
            if (nodes.size() > 1) {
                throw new CoreException("Several node components are the same name");
            }
            if (nodes.size() > 0) {
                res = (Node)nodes.get(0);
            }
        }
        catch (NoSuchInterfaceException e) {
            throw new CoreException((Throwable)e);
        }
        catch (SCAException e) {
            throw new CoreException((Throwable)e);
        }
        return res;
    }

    public void linkedNodeAndFunctionnalBehaviour(Node targetNode, Behaviour behaviour) throws CoreException {
        try {
            if (behaviour != null && targetNode != null) {
                Component targetComp = SCAHelper.getSCAHelper().getComponentByInterface(this.getComponent(), (Interface)targetNode, "service");
                Component activityComp = SCAHelper.getSCAHelper().getComponentByInterface(this.getComponent(), (Interface)behaviour, "service");
                if (targetComp == null || activityComp == null) {
                    throw new CoreException("Impossible to link node to a transition");
                }
                ArrayList<Binding> listOfBindings = new ArrayList<Binding>();
                listOfBindings.add(new Binding("behaviour", (Interface)activityComp.getFcInterface("service")));
                SCAHelper.getSCAHelper().addBindings(targetComp, listOfBindings);
                listOfBindings = new ArrayList();
                listOfBindings.add(new Binding("node", (Interface)targetComp.getFcInterface("service")));
                SCAHelper.getSCAHelper().addBindings(activityComp, listOfBindings);
            }
        }
        catch (NoSuchInterfaceException e) {
            log.finest(e.getMessage());
            throw new CoreException((Throwable)e);
        }
        catch (SCAException e) {
            throw new CoreException((Throwable)e);
        }
    }

    public void unlinkedNodeAndFunctionnalBehaviour(Node targetNode, Behaviour behaviour) throws CoreException {
        try {
            if (behaviour != null && targetNode != null) {
                Component targetComp = SCAHelper.getSCAHelper().getComponentByInterface(this.getComponent(), (Interface)targetNode, "service");
                Component activityComp = SCAHelper.getSCAHelper().getComponentByInterface(this.getComponent(), (Interface)behaviour, "service");
                if (targetComp == null || activityComp == null) {
                    throw new CoreException("Impossible to link node to a transition");
                }
                ArrayList<Binding> listOfBindings = new ArrayList<Binding>();
                listOfBindings.add(new Binding("behaviour", (Interface)activityComp.getFcInterface("service")));
                SCAHelper.getSCAHelper().deleteBindings(targetComp, listOfBindings);
                listOfBindings = new ArrayList();
                listOfBindings.add(new Binding("node", (Interface)targetComp.getFcInterface("service")));
                SCAHelper.getSCAHelper().deleteBindings(activityComp, listOfBindings);
            }
        }
        catch (NoSuchInterfaceException e) {
            log.finest(e.getMessage());
            throw new CoreException((Throwable)e);
        }
        catch (SCAException e) {
            throw new CoreException((Throwable)e);
        }
    }

    public void unlinkedNodeAndExecution(Node targetNode, Execution execution) throws CoreException {
        try {
            if (execution != null && targetNode != null) {
                Component targetComp = null;
                targetComp = SCAHelper.getSCAHelper().getComponentByInterface(this.getComponent(), (Interface)targetNode, "service");
                Component execComp = SCAHelper.getSCAHelper().getComponentByInterface(this.getComponent(), (Interface)execution, "service");
                if (targetComp == null || execComp == null) {
                    throw new CoreException("Impossible to unlink node to the execution ");
                }
                ArrayList<Binding> listOfBindings = new ArrayList<Binding>();
                listOfBindings.add(new Binding("execution", (Interface)execComp.getFcInterface("service")));
                SCAHelper.getSCAHelper().deleteBindings(targetComp, listOfBindings);
                listOfBindings = new ArrayList();
                listOfBindings.add(new Binding("currentTarget", (Interface)targetComp.getFcInterface("service")));
                SCAHelper.getSCAHelper().deleteBindings(execComp, listOfBindings);
            }
        }
        catch (NoSuchInterfaceException e) {
            log.finest(e.getMessage());
            throw new CoreException((Throwable)e);
        }
        catch (SCAException e) {
            throw new CoreException((Throwable)e);
        }
    }

    public Node unlinkBrotherNodes(Node sourceNode, Node targetNode) throws CoreException {
        Node res = null;
        try {
            Map mapOfBindings = SCAHelper.getSCAHelper().getListOfBindings(sourceNode.getComponent());
            Node afterNode = null;
            String afterName = null;
            for (Map.Entry e : mapOfBindings.entrySet()) {
                if (!((String)e.getKey()).startsWith("outgoingNodes")) continue;
                afterName = (String)e.getKey();
                afterNode = (Node)e.getValue();
                break;
            }
            res = afterNode;
            List cs = SCAHelper.getSCAHelper().getClientComponentsLinkedToServerInterfacesOfComponent(this.getComponent(), (Interface)sourceNode.getComponent().getFcInterface("service"));
            ArrayList<Boolean> started = new ArrayList<Boolean>();
            for (Component css : cs) {
                if (!SCAHelper.getSCAHelper().isStarted(css)) {
                    SCAHelper.getSCAHelper().startComponent(css);
                    started.add(Boolean.FALSE);
                    continue;
                }
                started.add(Boolean.TRUE);
            }
            Binding b = new Binding(afterName, (Interface)afterNode.getComponent().getFcInterface("service"));
            ArrayList<Binding> bindToDelete = new ArrayList<Binding>();
            bindToDelete.add(b);
            SCAHelper.getSCAHelper().deleteBindings(sourceNode.getComponent(), bindToDelete);
            int i = 0;
            for (Component css : cs) {
                if (!((Boolean)started.get(i)).booleanValue()) {
                    SCAHelper.getSCAHelper().stopComponent(css);
                }
                ++i;
            }
        }
        catch (SCAException e) {
            throw new CoreException((Throwable)e);
        }
        catch (NoSuchInterfaceException e) {
            throw new CoreException((Throwable)e);
        }
        return res;
    }

    public void linkedBrotherNodes(Node sourceNode, Node targetNode) throws CoreException {
        try {
            Component sourceComp = SCAHelper.getSCAHelper().getComponentByInterface(this.getComponent(), (Interface)sourceNode, "service");
            Component targetComp = SCAHelper.getSCAHelper().getComponentByInterface(this.getComponent(), (Interface)targetNode, "service");
            if (sourceComp == null || targetComp == null) {
                throw new CoreException("Impossible to link brother nodes");
            }
            ArrayList<Binding> listOfBindings = new ArrayList<Binding>();
            listOfBindings.add(new Binding("incomingNodes_" + this.formatCounter(cpt_incomingNode), (Interface)sourceComp.getFcInterface("service")));
            SCAHelper.getSCAHelper().addBindings(targetComp, listOfBindings);
            ++cpt_incomingNode;
            listOfBindings = new ArrayList();
            listOfBindings.add(new Binding("outgoingNodes" + this.formatCounter(cpt_outgoingNode), (Interface)targetComp.getFcInterface("service")));
            SCAHelper.getSCAHelper().addBindings(sourceComp, listOfBindings);
            ++cpt_outgoingNode;
        }
        catch (NoSuchInterfaceException e) {
            throw new CoreException((Throwable)e);
        }
        catch (SCAException e) {
            throw new CoreException((Throwable)e);
        }
    }

    public void linkedChildNodeToParent(Node parentNode, Node childrenNode) throws CoreException {
        try {
            Component parentComp = SCAHelper.getSCAHelper().getComponentByInterface(this.getComponent(), (Interface)parentNode, "service");
            Component childrenComp = SCAHelper.getSCAHelper().getComponentByInterface(this.getComponent(), (Interface)childrenNode, "service");
            if (parentComp == null || childrenComp == null) {
                throw new CoreException("Impossible to link parent and children node");
            }
            ArrayList<Binding> listOfBindings = new ArrayList<Binding>();
            listOfBindings.add(new Binding("childNodes_" + this.formatCounter(cpt_childsNode), (Interface)childrenComp.getFcInterface("service")));
            SCAHelper.getSCAHelper().addBindings(parentComp, listOfBindings);
            ++cpt_childsNode;
            listOfBindings = new ArrayList();
            listOfBindings.add(new Binding("parentNode", (Interface)parentComp.getFcInterface("service")));
            SCAHelper.getSCAHelper().addBindings(childrenComp, listOfBindings);
            SCAContentController scacc = (SCAContentController)childrenComp.getFcInterface("/sca-content-controller");
            NodeImpl nodeContent = null;
            try {
                nodeContent = (NodeImpl)((Object)scacc.getFcContent());
            }
            catch (ContentInstantiationException e) {
                throw new CoreException((Throwable)e);
            }
            if (nodeContent.getParentNode() == null) {
                nodeContent.setParentNode(parentNode);
            }
        }
        catch (NoSuchInterfaceException e) {
            throw new CoreException((Throwable)e);
        }
        catch (SCAException e) {
            throw new CoreException((Throwable)e);
        }
    }

    public void linkedExecution2ExecutableElement(Execution exe, Node target) throws CoreException {
        try {
            Component targetComp = null;
            targetComp = target instanceof Interface ? SCAHelper.getSCAHelper().getComponentByInterface(this.getComponent(), (Interface)target, "service") : SCAHelper.getSCAHelper().getComponentByInterface(this.getComponent(), (ServiceReference)target, "service");
            Component exeComp = SCAHelper.getSCAHelper().getComponentByInterface(this.getComponent(), (Interface)exe, "service");
            if (exeComp == null || targetComp == null) {
                throw new CoreException("Impossible to link the execution and the target node: exeComp = " + exeComp + " or targetComp = " + targetComp);
            }
            ArrayList<Binding> listOfBindings = new ArrayList<Binding>();
            listOfBindings.add(new Binding("currentTarget", (Interface)targetComp.getFcInterface("service")));
            if (SCAHelper.getSCAHelper().isBinded(exeComp, "currentTarget")) {
                throw new CoreException("Execution already bind");
            }
            SCAHelper.getSCAHelper().addBindings(exeComp, listOfBindings);
        }
        catch (NoSuchInterfaceException e) {
            throw new CoreException((Throwable)e);
        }
        catch (SCAException e) {
            throw new CoreException((Throwable)e);
        }
    }

    public void linkedExecutableElement2Execution(Node source, Execution exe) throws CoreException {
        try {
            Component sourceComp = SCAHelper.getSCAHelper().getComponentByInterface(this.getComponent(), (Interface)source, "service");
            Component exeComp = SCAHelper.getSCAHelper().getComponentByInterface(this.getComponent(), (Interface)exe, "service");
            if (exeComp == null || sourceComp == null) {
                throw new CoreException("Impossible to link the axecution and the target node");
            }
            if (!SCAHelper.getSCAHelper().isBinded(sourceComp, "execution")) {
                ArrayList<Binding> listOfBindings = new ArrayList<Binding>();
                listOfBindings = new ArrayList();
                listOfBindings.add(new Binding("execution", (Interface)exeComp.getFcInterface("service")));
                SCAHelper.getSCAHelper().addBindings(sourceComp, listOfBindings);
            }
        }
        catch (NoSuchInterfaceException e) {
            throw new CoreException((Throwable)e);
        }
        catch (SCAException e) {
            throw new CoreException((Throwable)e);
        }
    }

    public synchronized Execution createExecution(String execName) throws CoreException {
        log.finest("start the creation of execution: " + execName);
        Execution execution = null;
        Component fractalExecution = null;
        try {
            fractalExecution = SCAHelper.getSCAHelper().createNewComponent(ExecutionImpl.class.getName(), null);
            SCAHelper.getSCAHelper().addComponent(fractalExecution, this.getComponent(), null);
            SCAHelper.getSCAHelper().changeName(fractalExecution, execName);
            SCAContentController scacc = (SCAContentController)fractalExecution.getFcInterface("/sca-content-controller");
            try {
                execution = (Execution)scacc.getFcContent();
            }
            catch (ContentInstantiationException e) {
                throw new CoreException((Throwable)e);
            }
            if (!log.getName().equals(ScopeImpl.class.getName())) {
                execution.setLog(log);
            }
            execution = (Execution)fractalExecution.getFcInterface("service");
            log.finest("execution created: " + execName);
            if (this.getParentExecution() == null) {
                log.finest(String.valueOf(execName) + " is a parent execution");
                this.parentExecution = fractalExecution;
            }
        }
        catch (NoSuchInterfaceException e) {
            throw new CoreException((Throwable)e);
        }
        catch (SCAException e) {
            throw new CoreException((Throwable)e);
        }
        return execution;
    }

    public Map<QName, Variable> getVariables() {
        return this.variables;
    }

    public Variable findVariable(QName name) throws CoreException {
        Variable v = null;
        v = this.variables.get(name);
        if (v == null) {
            Scope current = this.getParentScope(this);
            while (v == null && current != null) {
                v = (Variable)current.getVariables().get(name);
                current = this.getParentScope(current);
            }
        }
        return v;
    }

    public List<CorrelationGroup> findCorrelationGroups(String name) throws CoreException {
        ArrayList<CorrelationGroup> res = new ArrayList<CorrelationGroup>();
        for (CorrelationGroup correlationGroup : this.correlationGroups) {
            if (correlationGroup.getCorrelations().get(name) == null) continue;
            res.add(correlationGroup);
        }
        Scope current = this.getParentScope(this);
        if (current != null) {
            res.addAll(current.findCorrelationGroups(name));
            current = this.getParentScope(current);
        }
        return res;
    }

    public Endpoint findEndpoint(Object key) throws CoreException {
        Endpoint ep = null;
        ep = this.endpoints.get(key);
        if (ep == null) {
            Scope current = this.getParentScope(this);
            while (ep == null && current != null) {
                ep = (Endpoint)current.getEndpoints().get(key);
                current = this.getParentScope(current);
            }
        }
        return ep;
    }

    public Object findEndpointKey(Endpoint edp) {
        Object key = null;
        for (Map.Entry<Object, Endpoint> currentEntry : this.getEndpoints().entrySet()) {
            if (!currentEntry.getValue().equals(edp)) continue;
            return currentEntry.getKey();
        }
        return key;
    }

    public <B extends Behaviour> List<B> findBehaviours(Class<B> behaviourClass) throws CoreException {
        return ScopeImpl.findBehaviours(behaviourClass, this.getComponent(), false);
    }

    public <B extends Behaviour> List<B> findBehaviours(Class<B> behaviourClass, boolean ignoreStoppedComponent) throws CoreException {
        return ScopeImpl.findBehaviours(behaviourClass, this.getComponent(), ignoreStoppedComponent);
    }

    public static <B extends Behaviour> List<B> findBehaviours(Class<B> behaviourClass, Component comp, boolean ignoreStopComponent) throws CoreException {
        ArrayList<Behaviour> behaviours = new ArrayList<Behaviour>();
        HashSet<Object> behavioursSet = new HashSet<Object>();
        try {
            List list = SCAHelper.getSCAHelper().getAllSubComponents(comp);
            for (Component component : list) {
                boolean isStarted = SCAHelper.getSCAHelper().isStarted(component);
                try {
                    Behaviour behaviour = (Behaviour)component.getFcInterface("service");
                    if (InstanceOfUtil.isClassExtendOfClass2found(behaviour.getClass(), behaviourClass)) {
                        if (ignoreStopComponent) {
                            SCAHelper.getSCAHelper().startComponent(component);
                            behavioursSet.add(behaviour);
                        } else if (isStarted) {
                            behavioursSet.add(behaviour);
                        }
                    }
                }
                catch (NoSuchInterfaceException behaviour) {
                }
                catch (ClassCastException behaviour) {
                    // empty catch block
                }
                try {
                    if (!(component.getFcInterface("service") instanceof Scope)) continue;
                    boolean wasStarted = SCAHelper.getSCAHelper().isStarted(component);
                    if (!wasStarted) {
                        SCAHelper.getSCAHelper().startComponent(component);
                    }
                    behavioursSet.addAll(ScopeImpl.findBehaviours(behaviourClass, component, ignoreStopComponent));
                    if (wasStarted) continue;
                    SCAHelper.getSCAHelper().stopComponent(component);
                }
                catch (NoSuchInterfaceException noSuchInterfaceException) {
                    // empty catch block
                }
            }
        }
        catch (SCAException sCAException) {
            throw new CoreException((Throwable)sCAException);
        }
        for (Behaviour behaviour : behavioursSet) {
            behaviours.add(behaviour);
        }
        return behaviours;
    }

    public void setVariable(Variable v) throws CoreException {
        ScopeImpl current = this;
        Variable var = (Variable)current.getVariables().get(v.getQName());
        if (var == null) {
            while (var == null && current != null) {
                var = (Variable)current.getVariables().get(v.getQName());
                current = this.getParentScope();
            }
        }
        if (current != null) {
            current.getVariables().put(v.getQName(), v);
        } else {
            this.getVariables().put(v.getQName(), v);
        }
    }

    public Scope getParentScope() throws CoreException {
        Process parent = null;
        try {
            Component parentComp;
            if (!(this instanceof Process) && (parentComp = SCAHelper.getSCAHelper().getParent(this.getComponent())) != null) {
                try {
                    parent = (Process)parentComp.getFcInterface("service");
                }
                catch (NoSuchInterfaceException e) {
                    parent = (Scope)parentComp.getFcInterface("service");
                }
                catch (ClassCastException e) {
                    parent = (Scope)parentComp.getFcInterface("service");
                }
            }
        }
        catch (NoSuchInterfaceException e) {
            throw new CoreException((Throwable)e);
        }
        catch (SCAException e) {
            throw new CoreException((Throwable)e);
        }
        return parent;
    }

    private Scope getParentScope(Scope child) throws CoreException {
        Scope parent = null;
        try {
            Component parentComp;
            if (!(child instanceof Process) && (parentComp = SCAHelper.getSCAHelper().getParent(child.getComponent())) != null) {
                parent = (Scope)parentComp.getFcInterface("service");
            }
        }
        catch (NoSuchInterfaceException noSuchInterfaceException) {
        }
        catch (SCAException sCAException) {
            // empty catch block
        }
        return parent;
    }

    public Process getProcess() throws CoreException {
        Process res = null;
        ScopeImpl current = this;
        ScopeImpl topScope = this;
        while (current != null) {
            if ((current = this.getParentScope(current)) == null) continue;
            topScope = current;
        }
        try {
            res = (Process)topScope.getComponent().getFcInterface("service");
        }
        catch (NoSuchInterfaceException noSuchInterfaceException) {
            // empty catch block
        }
        return res;
    }

    public void linkInitialNodeAndExecution() throws CoreException {
        log.finest("start linkInitialNodeAndExecution");
        try {
            if (this.initialNode != null) {
                if (!SCAHelper.getSCAHelper().isBinded(this.parentExecution, "currentTarget")) {
                    log.finest("bind execution to initial node");
                    ArrayList<Binding> listOfBindings = new ArrayList<Binding>();
                    listOfBindings.add(new Binding("currentTarget", (Interface)this.getInitialNode()));
                    SCAHelper.getSCAHelper().addBindings(this.parentExecution, listOfBindings);
                    log.finest("execution and initial node binded");
                }
                if (!SCAHelper.getSCAHelper().isAlreadyBind(this.initialNode, "execution", (Interface)this.parentExecution)) {
                    this.linkedExecutableElement2Execution((Node)this.initialNode.getFcInterface("service"), (Execution)this.parentExecution.getFcInterface("service"));
                    log.finest("initial and execution linked");
                }
            } else {
                log.finest("Initial node not setted");
            }
        }
        catch (NoSuchInterfaceException e) {
            log.severe(e.getMessage());
            throw new CoreException((Throwable)e);
        }
        catch (SCAException e) {
            log.severe(e.getMessage());
            throw new CoreException((Throwable)e);
        }
        log.finest("end of linkInitialNodeAndExecution");
    }

    @Override
    public void setLog(Logger logger) {
        super.setLog(logger);
        log = logger;
    }

    private String formatCounter(int cpt) {
        String res = "";
        res = cpt < 10 ? "000" + cpt : (cpt < 100 ? "00" + cpt : (cpt < 1000 ? "0" + cpt : String.valueOf(cpt)));
        return res;
    }

    public Map<Object, Endpoint> getEndpoints() {
        return this.endpoints;
    }

    public List<CorrelationGroup> getCorrelationGroups() {
        return this.correlationGroups;
    }

    public Map<Fault, Scope> getExceptions() {
        return this.exceptions;
    }

    public void setExceptions(Map<Fault, Scope> exceptions) {
        this.exceptions = exceptions;
    }

    public Exception isFaultScope() {
        return this.faultScope;
    }

    @Override
    public Node getParentNode() {
        return this.parentNode;
    }

    @Override
    public void setParentNode(Node parentNode) {
        this.parentNode = parentNode;
    }

    public void setFaultScope(Exception faultScope) {
        this.faultScope = faultScope;
    }

    public void setParentExecution(Component parentExecution) {
        this.parentExecution = parentExecution;
    }

    public void setTerminationHandler(TerminationHandler th) {
        this.terminationHandler = th;
    }

    public TerminationHandler getTerminationHandler() {
        return this.terminationHandler;
    }
}

