/*
 * Decompiled with CFR 0.152.
 */
package com.ebmwebsourcing.easyviper.core.impl.engine.registry;

import com.ebmwebsourcing.easyviper.core.api.CoreException;
import com.ebmwebsourcing.easyviper.core.api.engine.Engine;
import com.ebmwebsourcing.easyviper.core.api.engine.Execution;
import com.ebmwebsourcing.easyviper.core.api.engine.Process;
import com.ebmwebsourcing.easyviper.core.api.engine.registry.ProcessInstanceRegistry;
import com.ebmwebsourcing.easyviper.core.api.model.registry.ProcessKey;
import com.ebmwebsourcing.easyviper.core.api.soa.message.InternalMessage;
import com.ebmwebsourcing.easyviper.core.impl.model.registry.ProcessKeyImpl;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;

public class MemoryProcessInstanceRegistryImpl
implements ProcessInstanceRegistry {
    private final Logger log = Logger.getLogger(MemoryProcessInstanceRegistryImpl.class.getName());
    private final Map<ProcessKey, List<Process>> map = new HashMap<ProcessKey, List<Process>>();
    private final Engine engine;

    public MemoryProcessInstanceRegistryImpl(Engine engine) {
        this.engine = engine;
    }

    public List<Process> getProcessInstances(InternalMessage<?> message) {
        ProcessKeyImpl key = new ProcessKeyImpl();
        key.setEndpoint(message.getEndpoint());
        key.setService(message.getService());
        this.log.finest("tried key : " + ((Object)key).toString());
        String keys = null;
        Iterator<ProcessKey> it = this.map.keySet().iterator();
        while (it.hasNext()) {
            keys = keys == null ? it.next().toString() : String.valueOf(keys) + ", " + it.next().toString();
        }
        this.log.finest("available keys : " + keys);
        return this.map.get(key);
    }

    public List<Process> getProcessInstances(ProcessKey key) {
        List<Process> res = this.map.get(key);
        if (res == null) {
            res = new ArrayList<Process>();
        }
        return res;
    }

    public Process removeProcessInstance(Process process, boolean forceUninstall) throws CoreException {
        List keys = process.getProcessKeys();
        for (ProcessKey key : keys) {
            List<Process> processes = this.map.get(key);
            Process p = null;
            if (processes != null) {
                Iterator<Process> it = processes.iterator();
                while (it.hasNext()) {
                    p = it.next();
                    if (!p.getName().equals(process.getName())) continue;
                    if (forceUninstall) {
                        processes.remove(p);
                        this.engine.deleteProcess(p);
                        it = processes.iterator();
                        break;
                    }
                    if (p.getParentExecution() != null && p.getParentExecution().getState() == Execution.State.ENDED || p.getParentExecution() == null) {
                        processes.remove(p);
                        this.engine.deleteProcess(p);
                        it = processes.iterator();
                        break;
                    }
                    throw new CoreException("Impossible to remove this process instance (" + p.getName() + ") because it is not ended: state = " + p.getParentExecution().getState());
                }
            } else {
                this.log.finest("processes IS NULL ...");
            }
            List<Process> processesCleaned = this.map.get(key);
            if (processesCleaned != null && processesCleaned.size() != 0) continue;
            this.map.remove(key);
        }
        return process;
    }

    public void storeProcessInstance(ProcessKey key, Process process) throws CoreException {
        List<Process> processNames = this.map.get(key);
        if (processNames == null) {
            processNames = new ArrayList<Process>();
            this.map.put(key, processNames);
        }
        processNames.add(process);
        this.log.finest("instance stored: key = " + key + " - process: " + process.getName());
        this.log.finest("Number of process in key \"" + key + "\" : " + processNames.size());
    }

    public Map<ProcessKey, List<Process>> getMap() {
        return this.map;
    }

    public List<Process> getProcessInstances() {
        ArrayList<Process> res = new ArrayList<Process>();
        for (List<Process> processes : this.map.values()) {
            for (Process process : processes) {
                if (res.contains(process)) continue;
                res.add(process);
            }
        }
        return res;
    }
}

