/*
 * Decompiled with CFR 0.152.
 */
package com.ebmwebsourcing.easyviper.core.impl.model;

import com.ebmwebsourcing.easycommons.sca.helper.api.SCAException;
import com.ebmwebsourcing.easycommons.sca.helper.impl.SCAComponentImpl;
import com.ebmwebsourcing.easycommons.sca.helper.impl.SCAHelper;
import com.ebmwebsourcing.easyviper.core.api.Core;
import com.ebmwebsourcing.easyviper.core.api.CoreException;
import com.ebmwebsourcing.easyviper.core.api.model.Model;
import com.ebmwebsourcing.easyviper.core.api.model.compiler.AbstractCompiler;
import com.ebmwebsourcing.easyviper.core.api.model.compiler.Compiler;
import com.ebmwebsourcing.easyviper.core.api.model.registry.definition.AbstractProcessDefinitionRegistry;
import com.ebmwebsourcing.easyviper.core.api.model.registry.definition.ProcessDefinitionRegistry;
import java.util.logging.Logger;
import org.oasisopen.sca.annotation.PolicySets;
import org.oasisopen.sca.annotation.Scope;
import org.oasisopen.sca.annotation.Service;
import org.objectweb.fractal.api.Component;
import org.objectweb.fractal.api.NoSuchInterfaceException;
import org.ow2.frascati.tinfi.api.control.ContentInstantiationException;
import org.ow2.frascati.tinfi.api.control.SCAContentController;

@Scope(value="COMPOSITE")
@Service(value={Model.class}, names={"service"})
@PolicySets(value={"frascati:scaEasyCompositeWithContent"})
public class ModelImpl
extends SCAComponentImpl
implements Model {
    private static final long serialVersionUID = 1L;
    private Logger log = Logger.getLogger(ModelImpl.class.getName());
    private Component compilerComponent;
    private Component registryComponent;

    public Core getCore() throws CoreException {
        Core res = null;
        try {
            Component coreComp = SCAHelper.getSCAHelper().getParent(this.getComponent());
            res = (Core)coreComp.getFcInterface("service");
        }
        catch (NoSuchInterfaceException e) {
            throw new CoreException((Throwable)e);
        }
        catch (SCAException e) {
            throw new CoreException((Throwable)e);
        }
        return res;
    }

    public Compiler createCompiler(String name, Class<? extends AbstractCompiler> compilerClass) throws CoreException {
        if (this.compilerComponent != null) {
            throw new CoreException("Error: Registry already exist!!!");
        }
        Compiler compiler = null;
        try {
            this.compilerComponent = SCAHelper.getSCAHelper().createNewComponent(compilerClass.getName(), null);
            SCAHelper.getSCAHelper().addComponent(this.compilerComponent, this.getComponent(), null);
            compiler = (Compiler)((SCAContentController)this.compilerComponent.getFcInterface("/sca-content-controller")).getFcContent();
            if (!this.log.getName().equals(ModelImpl.class.getName())) {
                compiler.setLog(this.log);
            }
            SCAHelper.getSCAHelper().startComponent(this.compilerComponent);
            SCAHelper.getSCAHelper().changeName(this.compilerComponent, name);
            compiler = (Compiler)this.compilerComponent.getFcInterface("service");
        }
        catch (NoSuchInterfaceException e) {
            throw new CoreException((Throwable)e);
        }
        catch (ContentInstantiationException e) {
            throw new CoreException((Throwable)e);
        }
        catch (SCAException e) {
            throw new CoreException((Throwable)e);
        }
        this.log.finest("compiler created and started");
        return compiler;
    }

    public Compiler getCompiler() throws CoreException {
        Compiler res = null;
        try {
            if (this.compilerComponent != null) {
                Object obj = this.compilerComponent.getFcInterface("service");
                res = (Compiler)this.compilerComponent.getFcInterface("service");
            }
        }
        catch (NoSuchInterfaceException e) {
            throw new CoreException((Throwable)e);
        }
        return res;
    }

    public ProcessDefinitionRegistry createRegistry(String name, Class<? extends AbstractProcessDefinitionRegistry> registryClass) throws CoreException {
        ProcessDefinitionRegistry registry = null;
        if (this.registryComponent != null) {
            throw new CoreException("Error: Registry already exist!!!");
        }
        try {
            this.registryComponent = SCAHelper.getSCAHelper().createNewComponent(registryClass.getName(), null);
            SCAHelper.getSCAHelper().addComponent(this.registryComponent, this.getComponent(), null);
            registry = (ProcessDefinitionRegistry)((SCAContentController)this.registryComponent.getFcInterface("/sca-content-controller")).getFcContent();
            if (!this.log.getName().equals(ModelImpl.class.getName())) {
                registry.setLog(this.log);
            }
            SCAHelper.getSCAHelper().startComponent(this.registryComponent);
            SCAHelper.getSCAHelper().changeName(this.registryComponent, name);
            registry = (ProcessDefinitionRegistry)this.registryComponent.getFcInterface("service");
        }
        catch (NoSuchInterfaceException e) {
            throw new CoreException((Throwable)e);
        }
        catch (ContentInstantiationException e) {
            throw new CoreException((Throwable)e);
        }
        catch (SCAException e) {
            throw new CoreException((Throwable)e);
        }
        this.log.finest("registry created and started");
        return registry;
    }

    public ProcessDefinitionRegistry getRegistry() throws CoreException {
        ProcessDefinitionRegistry res = null;
        try {
            if (this.registryComponent != null) {
                Object obj = this.registryComponent.getFcInterface("service");
                res = (ProcessDefinitionRegistry)this.registryComponent.getFcInterface("service");
            }
        }
        catch (NoSuchInterfaceException e) {
            throw new CoreException((Throwable)e);
        }
        return res;
    }

    public void setLog(Logger logger) {
        this.log = logger;
    }
}

