/*
 * Decompiled with CFR 0.152.
 */
package com.ebmwebsourcing.easyviper.core.impl.engine.behaviour.functionnal;

import com.ebmwebsourcing.easyviper.core.api.CoreException;
import com.ebmwebsourcing.easyviper.core.api.engine.Execution;
import com.ebmwebsourcing.easyviper.core.api.engine.behaviour.AbstractComplexBehaviourImpl;
import com.ebmwebsourcing.easyviper.core.api.engine.behaviour.Behaviour;
import com.ebmwebsourcing.easyviper.core.api.engine.behaviour.functionnal.WaitBehaviour;
import com.ebmwebsourcing.easyviper.core.api.engine.expression.Expression;
import com.ebmwebsourcing.easyviper.core.impl.engine.time.WaitingThreadPool;
import java.util.Calendar;
import java.util.Date;
import javax.xml.datatype.DatatypeConfigurationException;
import javax.xml.datatype.DatatypeFactory;
import javax.xml.datatype.Duration;
import javax.xml.datatype.XMLGregorianCalendar;
import org.oasisopen.sca.annotation.Scope;
import org.oasisopen.sca.annotation.Service;
import org.osoa.sca.annotations.Property;

@Scope(value="COMPOSITE")
@Service(value={WaitBehaviour.class}, names={"service"})
public class WaitBehaviourImpl
extends AbstractComplexBehaviourImpl
implements WaitBehaviour {
    @Property(name="time", required=false)
    private Expression time;
    @Property(name="date", required=false)
    private Expression date;
    private boolean alreadyWaited;

    public Expression getDuration() {
        return this.time;
    }

    public void setDuration(Expression time) {
        this.time = time;
    }

    public Expression getDate() {
        return this.date;
    }

    public void setDate(Expression date) {
        this.date = date;
    }

    public void terminateWaiting(Execution execution) throws CoreException {
        this.alreadyWaited = true;
        this.selectNextNodeToExecute(execution, null);
        this.notifyParentBehaviour(execution, this.nextTarget);
    }

    protected Behaviour.State executeOnInactive(Execution execution) throws CoreException {
        if (this.alreadyWaited) {
            return Behaviour.State.ACTIVITY_STARTED;
        }
        if (this.time != null) {
            String durationString = this.getNode().getScope().getExpressionEvaluator().evaluateAsString(execution, this.time);
            try {
                Duration duration = DatatypeFactory.newInstance().newDuration(durationString);
                Long time = duration.getTimeInMillis(Calendar.getInstance());
                return this.doWait(execution, time);
            }
            catch (DatatypeConfigurationException e) {
                throw new CoreException("Impossible to evaluate time expression: " + this.time.getContent());
            }
        }
        assert (this.date != null);
        String dateString = this.getNode().getScope().getExpressionEvaluator().evaluateAsString(execution, this.date);
        try {
            XMLGregorianCalendar xmlCalendar = DatatypeFactory.newInstance().newXMLGregorianCalendar(dateString);
            Date date = xmlCalendar.toGregorianCalendar().getTime();
            this.log.fine("execute wait behaviour on node: " + this.getNode().getName() + " => wait until " + date);
            return this.doWait(execution, date.getTime() - System.currentTimeMillis());
        }
        catch (DatatypeConfigurationException e) {
            throw new CoreException("Impossible to evaluate date expression: " + this.date.getContent());
        }
    }

    private final Behaviour.State doWait(Execution execution, long time) {
        if (time >= 0L) {
            this.log.fine("wait during " + time + " ms");
            execution.setStateRecursively(Execution.State.SUSPENDED);
            WaitingThreadPool.addWaitingThread(execution, this, time);
            this.selectNextNodeToExecute(execution, null);
            return Behaviour.State.ACTIVITY_STARTED;
        }
        return Behaviour.State.ACTIVITY_ENDED;
    }

    protected Behaviour.State executeOnStarted(Execution execution) throws CoreException {
        if (this.alreadyWaited) {
            this.alreadyWaited = false;
            return Behaviour.State.ACTIVITY_ENDED;
        }
        return Behaviour.State.ACTIVITY_STARTED;
    }

    protected Behaviour.State executeOnEnded(Execution execution) throws CoreException {
        this.alreadyWaited = false;
        return super.executeOnEnded(execution);
    }
}

