/****************************************************************************
 *
 * Copyright (c) 2009-2012, EBM WebSourcing
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA 
 *
 *****************************************************************************/
 
package com.ebmwebsourcing.easyviper.core.impl.engine.behaviour.functionnal;

import java.util.Map;

import javax.xml.namespace.QName;

import org.jdom.Element;
import org.jdom.output.Format;
import org.jdom.output.XMLOutputter;
import org.osoa.sca.annotations.Property;

import com.ebmwebsourcing.easyviper.core.api.CoreException;
import com.ebmwebsourcing.easyviper.core.api.engine.Execution;
import com.ebmwebsourcing.easyviper.core.api.engine.Scope;
import com.ebmwebsourcing.easyviper.core.api.engine.behaviour.AbstractSimpleBehaviourImpl;
import com.ebmwebsourcing.easyviper.core.api.engine.behaviour.functionnal.SenderBehaviour;
import com.ebmwebsourcing.easyviper.core.api.engine.fault.FaultHandler;
import com.ebmwebsourcing.easyviper.core.api.engine.variable.Variable;
import com.ebmwebsourcing.easyviper.core.api.env.ExternalContext;
import com.ebmwebsourcing.easyviper.core.api.soa.Partner;
import com.ebmwebsourcing.easyviper.core.api.soa.correlation.CorrelationMatcher;
import com.ebmwebsourcing.easyviper.core.api.soa.message.BindingInputMessageAdapter;
import com.ebmwebsourcing.easyviper.core.api.soa.message.BindingMessageAdapter.Direction;
import com.ebmwebsourcing.easyviper.core.api.soa.message.BindingOutputMessageAdapter;
import com.ebmwebsourcing.easyviper.core.api.soa.message.Message;
import com.ebmwebsourcing.easyviper.core.impl.engine.ProcessImpl;

/**
 * @author Nicolas Salatge - EBM WebSourcing
 */
@org.oasisopen.sca.annotation.Scope("COMPOSITE")
@org.oasisopen.sca.annotation.Service(value = SenderBehaviour.class, names = "service")
public class SenderBehaviourImpl extends AbstractSimpleBehaviourImpl implements SenderBehaviour {

    @Property(name = "kind", required = true)
    private Kind kind;

    @Property(name = "inputVariableName", required = true)
    private String inputVariableName;

    @Property(name = "outputVariableName", required = true)
    private String outputVariableName;

    @Property(name = "partnerName", required = false)
    private String partnerName;

    @Property(name = "operationName", required = false)
    private String operationName;

    @Property(name = "interfaceName", required = false)
    private QName interfaceName;

    @Property(name = "outputMessageAdapter", required = false)
    private BindingOutputMessageAdapter outputMessageAdapter;

    @Property(name = "inputMessageAdapter", required = false)
    private BindingInputMessageAdapter inputMessageAdapter;

    @Property(name = "faultHandler", required = false)
    private FaultHandler faultHandler;

    @Property(name = "isReply", required = false)
    private boolean isReply = false;

    private void sendTo(Execution execution, final Message message, String address,
    		Map<Partner, Map<String,ExternalContext>> context, boolean isReply) throws CoreException {
        final com.ebmwebsourcing.easyviper.core.api.engine.Process p = execution.getCurrentTarget()
                .getProcess();
        p.getEngine().sendTo(message, address, context, isReply);
    }

    private Message sendSyncTo(Execution execution, final Message request, String address,
    		Map<Partner, Map<String,ExternalContext>> context) throws CoreException {
        final com.ebmwebsourcing.easyviper.core.api.engine.Process p = execution.getCurrentTarget()
                .getProcess();
        return p.getEngine().sendSyncTo(request, address, context);
    }

    public CorrelationMatcher getCorrelationMatcher() {
        // TODO Auto-generated method stub
        return null;
    }

    public void setCorrelationMatcher(CorrelationMatcher correlationMatcher) {
        // TODO Auto-generated method stub

    }

    @Override
    protected void doExecute(Execution execution) {
        final Scope scope = getNode().getScope();
        final Variable inputVariable = scope.findVariable(this.inputVariableName);

        if (inputVariable == null) {
            throw new CoreException("Input Variable " + this.inputVariableName
                    + " not found in behaviour: " + this.getName());
        }

        if (this.kind == null) {
            throw new CoreException("Kind cannot be null");
        }

        if (this.partnerName != null) {
            Partner partner = scope.findPartner(this.partnerName);
            if (partner == null) {
                throw new CoreException("Provider Endpoint cannot be null");
            }

            boolean isBindingStyleRpc = false;
            Direction direction = Direction.REQUEST;

            try {
                String endpointName = scope.getPartnerEvaluator().getEndpointName(
                        partner.getValue(execution));
                QName serviceName = scope.getPartnerEvaluator().getServiceName(
                        partner.getValue(execution));

                if (this.kind == Kind.ASYNCHRONOUS) {
                    this.log.fine("asynchronous send");

                    Message outputMessage = null;

                    if (this.outputMessageAdapter != null) {
                        isBindingStyleRpc = outputMessageAdapter.isBindingStyleRpc(endpointName,
                                serviceName, interfaceName, operationName);
                        direction = isReply ? Direction.RESPONSE : Direction.REQUEST;
                        outputMessage = this.outputMessageAdapter.adaptToBindingOutput(execution,
                                inputVariable, endpointName, serviceName, interfaceName,
                                operationName, direction, isBindingStyleRpc);
                        log.fine("adapt the message: " + outputMessage);
                    }

                    this.sendTo(execution, outputMessage, getNode().getScope()
                            .getPartnerEvaluator().getAddress(partner.getValue(execution)),
                            getNode().getProcess().getExternalContexts(), isReply);

                } else if (this.kind == Kind.SYNCHRONOUS) {
                    this.log.fine("synchronous send");
                    final Variable outputVariable = scope.findVariable(this.outputVariableName);

                    if (outputVariable == null) {
                        throw new CoreException("Output Variable " + this.outputVariableName
                                + " not found in behaviour: " + this.getName());
                    }

                    Message outputMessage = null;
                    isBindingStyleRpc = outputMessageAdapter.isBindingStyleRpc(endpointName,
                            serviceName, interfaceName, operationName);
                    outputMessage = this.outputMessageAdapter.adaptToBindingOutput(execution, inputVariable,
                            endpointName, serviceName, interfaceName, operationName, direction,
                            isBindingStyleRpc);
                    log.fine("operation name : " + this.operationName);

                    Message response = this.sendSyncTo(execution, outputMessage, scope
                            .getPartnerEvaluator().getAddress(partner.getValue(execution)),
                            getNode().getProcess().getExternalContexts());

                    inputMessageAdapter.adaptFromBindingInput(execution, response, outputVariable,
                            Direction.RESPONSE, isBindingStyleRpc);
                    
                    log.fine("set outpuvariable " + outputVariable.getName() + " with value:\n" + new XMLOutputter(Format.getPrettyFormat()).outputString((Element)outputVariable.getValue(execution)));
                }
            } catch (CoreException e) {
                if (this.faultHandler != null) {
                    CoreException modelException = this.faultHandler
                            .getBPELExceptionFromGenericException(scope, e, direction,
                                    isBindingStyleRpc);
                    if (modelException != null) {
                        throw modelException;
                    } else {
                        throw e;
                    }

                } else {
                    log.warning("exception handler is null");
                    throw e;
                }

            }
        } else {
            this.log.fine("the provider Endpoint Key is null");
        }
    }

}
