/****************************************************************************
 *
 * Copyright (c) 2009-2012, EBM WebSourcing
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA 
 *
 *****************************************************************************/
 
package com.ebmwebsourcing.easyviper.core.impl.soa.message;

import java.util.HashMap;
import java.util.Map;

import javax.xml.namespace.QName;

import org.w3c.dom.Document;

import com.ebmwebsourcing.easyviper.core.api.soa.message.Header;

/**
 * @author Nicolas Salatge - EBM WebSourcing
 */
public class HeaderImpl implements Header {

	private Map<QName, Document> properties;
	
	
	public HeaderImpl() {
		properties = new HashMap<QName, Document>();
	}
	
	public void addProperty(QName id, Document prop) {
		this.properties.put(id, prop);
	}

	public void clearProperties() {
		this.properties.clear();

	}

	public Document[] getProperties() {
		return (Document[]) this.properties.values().toArray();
	}
	
	public Map<QName, Document> getPropertiesMap(){
		return this.properties;
	}

	public Document getProperty(QName qname) {
		return this.properties.get(qname);
	}

	public Document removeProperty(QName qname) {
		return this.properties.remove(qname);
	}

}
