/****************************************************************************
 *
 * Copyright (c) 2009-2012, EBM WebSourcing
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA 
 *
 *****************************************************************************/
 
package com.ebmwebsourcing.easyviper.core.impl.soa.message;

import javax.xml.namespace.QName;

import org.jdom.output.Format;
import org.jdom.output.XMLOutputter;
import org.ow2.easywsdl.schema.api.abstractElmt.AbstractSchemaElementImpl;

import com.ebmwebsourcing.easyviper.core.api.soa.message.Body;
import com.ebmwebsourcing.easyviper.core.api.soa.message.Header;
import com.ebmwebsourcing.easyviper.core.api.soa.message.Message;
import com.ebmwebsourcing.easyviper.model.Tinternalmessage;

/**
 * @author Nicolas Salatge - EBM WebSourcing
 */
public class MessageImpl extends AbstractSchemaElementImpl<Tinternalmessage> implements Message {

    private Body body;

    private Header header;

    /**
     * 
     */
    private static final long serialVersionUID = 1L;

    public MessageImpl(String operationName) {
        super();
        assert operationName != null;
        this.model = new Tinternalmessage();
        this.model.setOperation(operationName);
        this.body = new BodyImpl();

    }

    public MessageImpl(Tinternalmessage model, AbstractSchemaElementImpl<?> parent) {
        super(model, parent);

    }

    public String getEndpoint() {
        return this.model.getEndpoint();
    }


    @Override
    public QName getInterface() {
        return model.getInterface();
    }

    @Override
    public void setInterface(QName interfac) {
        model.setInterface(interfac);
    }
    
    
    public String getOperationName() {
        return this.model.getOperation(); 
    }


    public QName getQName() {
        return this.model.getQname();
    }


    public QName getService() {
        return this.model.getService();
    }


    public void setEndpoint(String arg0) {
        this.model.setEndpoint(arg0);

    }


    public void setQName(QName arg0) {
        this.model.setQname(arg0);

    }


    public void setService(QName arg0) {
        this.model.setService(arg0);
    }

    public Body getBody(){
        return this.body;
    }

    public void setBody(Body body){
        this.body = body;
    }

    public Header getHeader(){
        return this.header;
    }

    public void setHeader(Header header){
        this.header = header;
    }

    @Override
    public String toString() {
        return new XMLOutputter(Format.getPrettyFormat()).outputString(getBody().getPayload());
    }

  
}
