/****************************************************************************
 *
 * Copyright (c) 2009-2012, EBM WebSourcing
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA 
 *
 *****************************************************************************/
 
package com.ebmwebsourcing.easyviper.tools;

import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;

import javax.xml.namespace.QName;

import com.ebmwebsourcing.easyviper.core.api.soa.message.Message;
import com.ebmwebsourcing.easyviper.core.impl.soa.message.MessageImpl;

/**
 * @author Nicolas Salatge - EBM WebSourcing
 */
public class DatedExternalMessage extends MessageImpl implements
		Message {

	private Date date;

	private final Message msg;

	public DatedExternalMessage(final Message msg) {
	    super(msg.getOperationName());
		this.date = Calendar.getInstance().getTime();
		this.msg = msg;
	}

	public Date getDate() {
		return this.date;
	}

	public void setDate(final Date date) {
		this.date = date;
	}

	@Override
	public String getEndpoint() {
		return this.msg.getEndpoint();
	}

	@Override
	public QName getQName() {
		return this.msg.getQName();
	}

	@Override
	public QName getService() {
		return this.msg.getService();
	}

	@Override
	public void setEndpoint(final String endpoint) {
		this.msg.setEndpoint(endpoint);
	}

	@Override
	public void setQName(final QName name) {
		this.msg.setQName(name);
	}

	@Override
	public void setService(final QName service) {
		this.msg.setService(service);
	}

	public String formatDate2String() {
		String res = null;
		final Date d = this.date;
		if (d != null) {

			// year - month - day
			final Calendar c = new GregorianCalendar();
			c.setTime(d);
			final int day = c.get(Calendar.DAY_OF_MONTH);
			String dayS = String.valueOf(day);
			if (day < 10) {
				dayS = "0" + day;
			}
			final int month = c.get(Calendar.MONTH) + 1;
			String monthS = String.valueOf(c.get(Calendar.MONTH) + 1);
			if (month < 10) {
				monthS = "0" + month;
			}
			final int year = c.get(Calendar.YEAR);
			final String yearS = String.valueOf(year);
			res = dayS + "/" + monthS + "/" + yearS;

			// hours - minute -secon
			final int hours = c.get(Calendar.HOUR_OF_DAY);
			String hoursS = String.valueOf(hours);
			if (hours < 10) {
				hoursS = "0" + hoursS;
			}

			final int minute = c.get(Calendar.MINUTE);
			String minuteS = String.valueOf(minute);
			if (minute < 10) {
				minuteS = "0" + minuteS;
			}

			final int second = c.get(Calendar.SECOND);
			String secondS = String.valueOf(second);
			if (second < 10) {
				secondS = "0" + secondS;
			}

			res = res + " " + hoursS + "h" + minuteS + ":" + secondS;

		}
		return res;
	}
}
