/*
 * Decompiled with CFR 0.152.
 */
package com.ebmwebsourcing.easyviper.core.impl.test.pattern.creation;

import com.ebmwebsourcing.easycommons.sca.helper.api.SCAException;
import com.ebmwebsourcing.easyviper.core.api.Core;
import com.ebmwebsourcing.easyviper.core.api.CoreException;
import com.ebmwebsourcing.easyviper.core.api.engine.Execution;
import com.ebmwebsourcing.easyviper.core.api.engine.ExpressionEvaluator;
import com.ebmwebsourcing.easyviper.core.api.engine.Node;
import com.ebmwebsourcing.easyviper.core.api.engine.Process;
import com.ebmwebsourcing.easyviper.core.api.engine.Scope;
import com.ebmwebsourcing.easyviper.core.impl.AbstractCoreTest;
import com.ebmwebsourcing.easyviper.core.impl.TestExpressionImpl;
import com.ebmwebsourcing.easyviper.core.impl.engine.behaviour.functionnal.EmptyBehaviourImpl;
import com.ebmwebsourcing.easyviper.core.impl.engine.pattern.CreationPatternFactory;
import java.util.ArrayList;
import javax.xml.namespace.QName;
import org.junit.Test;
import org.mockito.Mockito;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.stubbing.Answer;
import org.objectweb.fractal.api.NoSuchInterfaceException;

public class IfPatternTest
extends AbstractCoreTest {
    @Test
    public void testIfValidIfPattern() throws CoreException, NoSuchInterfaceException, InterruptedException, SCAException {
        Core core = this.getCoreUnderTest();
        Process process = core.getEngine().createNewEmptyProcessInstance(new QName("ifProcess"), null);
        TestExpressionImpl exp = new TestExpressionImpl("true");
        final boolean[] mockAnswers = new boolean[]{true};
        ExpressionEvaluator mockExpressionEvaluator = (ExpressionEvaluator)Mockito.mock(ExpressionEvaluator.class, (Answer)new Answer<Boolean>(){
            int i = 0;

            public Boolean answer(InvocationOnMock invocation) throws Throwable {
                return mockAnswers[this.i++];
            }
        });
        process.setExpressionEvaluator(mockExpressionEvaluator);
        ArrayList<TestExpressionImpl> expressions = new ArrayList<TestExpressionImpl>();
        expressions.add(exp);
        ArrayList<Node> childNodes = new ArrayList<Node>();
        childNodes.add(process.createNode("first", EmptyBehaviourImpl.class, null));
        Node initial = CreationPatternFactory.getInstance().createIfPattern("if", expressions, childNodes, (Scope)process);
        process.setInitialNode(initial);
        Execution execution = core.getEngine().run(process);
        this.checkExecutionEndedProperly(execution);
    }

    @Test
    public void testIfInValidPattern() throws CoreException, NoSuchInterfaceException, InterruptedException, SCAException {
        Core core = this.getCoreUnderTest();
        Process process = core.getEngine().createNewEmptyProcessInstance(new QName("ifProcess"), null);
        TestExpressionImpl exp = new TestExpressionImpl("false");
        ArrayList<TestExpressionImpl> expressions = new ArrayList<TestExpressionImpl>();
        expressions.add(exp);
        final boolean[] mockAnswers = new boolean[]{false};
        ExpressionEvaluator mockExpressionEvaluator = (ExpressionEvaluator)Mockito.mock(ExpressionEvaluator.class, (Answer)new Answer<Boolean>(){
            int i = 0;

            public Boolean answer(InvocationOnMock invocation) throws Throwable {
                return mockAnswers[this.i++];
            }
        });
        process.setExpressionEvaluator(mockExpressionEvaluator);
        ArrayList<Node> childNodes = new ArrayList<Node>();
        childNodes.add(process.createNode("first", EmptyBehaviourImpl.class, null));
        Node initial = CreationPatternFactory.getInstance().createIfPattern("if", expressions, childNodes, (Scope)process);
        process.setInitialNode(initial);
        Execution execution = core.getEngine().run(process);
        this.checkExecutionEndedProperly(execution);
    }

    @Test
    public void testIfElseValidIfPattern() throws CoreException, NoSuchInterfaceException, InterruptedException, SCAException {
        Core core = this.getCoreUnderTest();
        Process process = core.getEngine().createNewEmptyProcessInstance(new QName("ifProcess"), null);
        TestExpressionImpl exp = new TestExpressionImpl("true");
        final boolean[] mockAnswers = new boolean[]{true};
        ExpressionEvaluator mockExpressionEvaluator = (ExpressionEvaluator)Mockito.mock(ExpressionEvaluator.class, (Answer)new Answer<Boolean>(){
            int i = 0;

            public Boolean answer(InvocationOnMock invocation) throws Throwable {
                return mockAnswers[this.i++];
            }
        });
        process.setExpressionEvaluator(mockExpressionEvaluator);
        ArrayList<TestExpressionImpl> expressions = new ArrayList<TestExpressionImpl>();
        expressions.add(exp);
        ArrayList<Node> childNodes = new ArrayList<Node>();
        childNodes.add(process.createNode("first", EmptyBehaviourImpl.class, null));
        childNodes.add(process.createNode("else", EmptyBehaviourImpl.class, null));
        Node initial = CreationPatternFactory.getInstance().createIfPattern("if", expressions, childNodes, (Scope)process);
        process.setInitialNode(initial);
        Execution execution = core.getEngine().run(process);
        this.checkExecutionEndedProperly(execution);
    }

    @Test
    public void testIfElseValidElsePattern() throws CoreException, NoSuchInterfaceException, InterruptedException, SCAException {
        Core core = this.getCoreUnderTest();
        Process process = core.getEngine().createNewEmptyProcessInstance(new QName("ifProcess"), null);
        TestExpressionImpl exp = new TestExpressionImpl("false");
        ArrayList<TestExpressionImpl> expressions = new ArrayList<TestExpressionImpl>();
        expressions.add(exp);
        final boolean[] mockAnswers = new boolean[]{false};
        ExpressionEvaluator mockExpressionEvaluator = (ExpressionEvaluator)Mockito.mock(ExpressionEvaluator.class, (Answer)new Answer<Boolean>(){
            int i = 0;

            public Boolean answer(InvocationOnMock invocation) throws Throwable {
                return mockAnswers[this.i++];
            }
        });
        process.setExpressionEvaluator(mockExpressionEvaluator);
        ArrayList<Node> childNodes = new ArrayList<Node>();
        childNodes.add(process.createNode("first", EmptyBehaviourImpl.class, null));
        childNodes.add(process.createNode("else", EmptyBehaviourImpl.class, null));
        Node initial = CreationPatternFactory.getInstance().createIfPattern("if", expressions, childNodes, (Scope)process);
        process.setInitialNode(initial);
        Execution execution = core.getEngine().run(process);
        this.checkExecutionEndedProperly(execution);
    }

    @Test
    public void testIfElseIfValidFirstPattern() throws CoreException, NoSuchInterfaceException, InterruptedException, SCAException {
        Core core = this.getCoreUnderTest();
        Process process = core.getEngine().createNewEmptyProcessInstance(new QName("ifProcess"), null);
        TestExpressionImpl exp1 = new TestExpressionImpl("true");
        TestExpressionImpl exp2 = new TestExpressionImpl("false");
        TestExpressionImpl exp3 = new TestExpressionImpl("false");
        ArrayList<TestExpressionImpl> expressions = new ArrayList<TestExpressionImpl>();
        expressions.add(exp1);
        expressions.add(exp2);
        expressions.add(exp3);
        final boolean[] mockAnswers = new boolean[]{true, false, false};
        ExpressionEvaluator mockExpressionEvaluator = (ExpressionEvaluator)Mockito.mock(ExpressionEvaluator.class, (Answer)new Answer<Boolean>(){
            int i = 0;

            public Boolean answer(InvocationOnMock invocation) throws Throwable {
                return mockAnswers[this.i++];
            }
        });
        process.setExpressionEvaluator(mockExpressionEvaluator);
        ArrayList<Node> childNodes = new ArrayList<Node>();
        childNodes.add(process.createNode("first", EmptyBehaviourImpl.class, null));
        childNodes.add(process.createNode("second", EmptyBehaviourImpl.class, null));
        childNodes.add(process.createNode("third", EmptyBehaviourImpl.class, null));
        Node initial = CreationPatternFactory.getInstance().createIfPattern("if", expressions, childNodes, (Scope)process);
        process.setInitialNode(initial);
        Execution execution = core.getEngine().run(process);
        this.checkExecutionEndedProperly(execution);
    }

    @Test
    public void testIfElseIfValidSecondPattern() throws CoreException, NoSuchInterfaceException, InterruptedException, SCAException {
        Core core = this.getCoreUnderTest();
        Process process = core.getEngine().createNewEmptyProcessInstance(new QName("ifProcess"), null);
        TestExpressionImpl exp1 = new TestExpressionImpl("false");
        TestExpressionImpl exp2 = new TestExpressionImpl("true");
        TestExpressionImpl exp3 = new TestExpressionImpl("false");
        ArrayList<TestExpressionImpl> expressions = new ArrayList<TestExpressionImpl>();
        expressions.add(exp1);
        expressions.add(exp2);
        expressions.add(exp3);
        final boolean[] mockAnswers = new boolean[]{false, true, false};
        ExpressionEvaluator mockExpressionEvaluator = (ExpressionEvaluator)Mockito.mock(ExpressionEvaluator.class, (Answer)new Answer<Boolean>(){
            int i = 0;

            public Boolean answer(InvocationOnMock invocation) throws Throwable {
                return mockAnswers[this.i++];
            }
        });
        process.setExpressionEvaluator(mockExpressionEvaluator);
        ArrayList<Node> childNodes = new ArrayList<Node>();
        childNodes.add(process.createNode("first", EmptyBehaviourImpl.class, null));
        childNodes.add(process.createNode("second", EmptyBehaviourImpl.class, null));
        childNodes.add(process.createNode("third", EmptyBehaviourImpl.class, null));
        Node initial = CreationPatternFactory.getInstance().createIfPattern("if", expressions, childNodes, (Scope)process);
        process.setInitialNode(initial);
        Execution execution = core.getEngine().run(process);
        this.checkExecutionEndedProperly(execution);
    }

    @Test
    public void testIfElseIfValidThirdPattern() throws CoreException, NoSuchInterfaceException, InterruptedException, SCAException {
        Core core = this.getCoreUnderTest();
        Process process = core.getEngine().createNewEmptyProcessInstance(new QName("ifProcess"), null);
        TestExpressionImpl exp1 = new TestExpressionImpl("false");
        TestExpressionImpl exp2 = new TestExpressionImpl("false");
        TestExpressionImpl exp3 = new TestExpressionImpl("true");
        ArrayList<TestExpressionImpl> expressions = new ArrayList<TestExpressionImpl>();
        expressions.add(exp1);
        expressions.add(exp2);
        expressions.add(exp3);
        final boolean[] mockAnswers = new boolean[]{false, false, true};
        ExpressionEvaluator mockExpressionEvaluator = (ExpressionEvaluator)Mockito.mock(ExpressionEvaluator.class, (Answer)new Answer<Boolean>(){
            int i = 0;

            public Boolean answer(InvocationOnMock invocation) throws Throwable {
                return mockAnswers[this.i++];
            }
        });
        process.setExpressionEvaluator(mockExpressionEvaluator);
        ArrayList<Node> childNodes = new ArrayList<Node>();
        childNodes.add(process.createNode("first", EmptyBehaviourImpl.class, null));
        childNodes.add(process.createNode("second", EmptyBehaviourImpl.class, null));
        childNodes.add(process.createNode("third", EmptyBehaviourImpl.class, null));
        Node initial = CreationPatternFactory.getInstance().createIfPattern("if", expressions, childNodes, (Scope)process);
        process.setInitialNode(initial);
        Execution execution = core.getEngine().run(process);
        this.checkExecutionEndedProperly(execution);
    }
}

