/*
 * Decompiled with CFR 0.152.
 */
package com.ebmwebsourcing.easyviper.core.impl.test.pattern.creation;

import com.ebmwebsourcing.easycommons.sca.helper.api.SCAException;
import com.ebmwebsourcing.easyviper.core.api.Core;
import com.ebmwebsourcing.easyviper.core.api.CoreException;
import com.ebmwebsourcing.easyviper.core.api.engine.Engine;
import com.ebmwebsourcing.easyviper.core.api.engine.Execution;
import com.ebmwebsourcing.easyviper.core.api.engine.ExpressionEvaluator;
import com.ebmwebsourcing.easyviper.core.api.engine.Node;
import com.ebmwebsourcing.easyviper.core.api.engine.Process;
import com.ebmwebsourcing.easyviper.core.api.engine.Scope;
import com.ebmwebsourcing.easyviper.core.api.engine.expression.Expression;
import com.ebmwebsourcing.easyviper.core.impl.AbstractCoreTest;
import com.ebmwebsourcing.easyviper.core.impl.TestExpressionImpl;
import com.ebmwebsourcing.easyviper.core.impl.engine.behaviour.functionnal.EmptyBehaviourImpl;
import com.ebmwebsourcing.easyviper.core.impl.engine.pattern.CreationPatternFactory;
import java.util.ArrayList;
import java.util.List;
import javax.xml.namespace.QName;
import org.junit.Test;
import org.mockito.Mockito;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.stubbing.Answer;
import org.objectweb.fractal.api.NoSuchInterfaceException;

public class LoopPatternTest
extends AbstractCoreTest {
    @Test
    public void testWhilePattern() throws CoreException, NoSuchInterfaceException, InterruptedException, SCAException {
        Core core = this.getCoreUnderTest();
        Engine engine = core.getEngine();
        Process process = core.getEngine().createNewEmptyProcessInstance(new QName("WhileProcess"), null);
        ArrayList<Node> childNodes = new ArrayList<Node>();
        childNodes.add(process.createNode("first", EmptyBehaviourImpl.class, null));
        childNodes.add(process.createNode("second", EmptyBehaviourImpl.class, null));
        childNodes.add(process.createNode("third", EmptyBehaviourImpl.class, null));
        TestExpressionImpl condition = new TestExpressionImpl("dummy");
        final boolean[] mockAnswers = new boolean[]{true, true, false};
        ExpressionEvaluator mockExpressionEvaluator = (ExpressionEvaluator)Mockito.mock(ExpressionEvaluator.class, (Answer)new Answer<Boolean>(){
            int i = 0;

            public Boolean answer(InvocationOnMock invocation) throws Throwable {
                return mockAnswers[this.i++];
            }
        });
        process.setExpressionEvaluator(mockExpressionEvaluator);
        Node initial = CreationPatternFactory.getInstance().createLoopPattern("while", (Expression)condition, true, childNodes, (Scope)process);
        process.setInitialNode(initial);
        Execution main = engine.run(process);
        this.checkExecutionEndedProperly(main);
    }

    @Test
    public void testWhileWithoutUnderActivityPattern() throws CoreException, NoSuchInterfaceException, InterruptedException, SCAException {
        Core core = this.getCoreUnderTest();
        Engine engine = core.getEngine();
        Process process = core.getEngine().createNewEmptyProcessInstance(new QName("WhileProcess"), null);
        TestExpressionImpl condition = new TestExpressionImpl("dummy");
        final boolean[] mockAnswers = new boolean[]{true, true, false};
        ExpressionEvaluator mockExpressionEvaluator = (ExpressionEvaluator)Mockito.mock(ExpressionEvaluator.class, (Answer)new Answer<Boolean>(){
            int i = 0;

            public Boolean answer(InvocationOnMock invocation) throws Throwable {
                return mockAnswers[this.i++];
            }
        });
        process.setExpressionEvaluator(mockExpressionEvaluator);
        List childNodes = null;
        Node initial = CreationPatternFactory.getInstance().createLoopPattern("while", (Expression)condition, true, childNodes, (Scope)process);
        process.setInitialNode(initial);
        Execution main = engine.run(process);
        this.checkExecutionEndedProperly(main);
    }

    @Test
    public void testWhileWithSequenceInsideAndWithNodeAroundPattern() throws CoreException, NoSuchInterfaceException, InterruptedException, SCAException {
        Core core = this.getCoreUnderTest();
        Engine engine = core.getEngine();
        Process process = core.getEngine().createNewEmptyProcessInstance(new QName("WhileProcess"), null);
        TestExpressionImpl condition = new TestExpressionImpl("dummy");
        final boolean[] mockAnswers = new boolean[]{true, true, false};
        ExpressionEvaluator mockExpressionEvaluator = (ExpressionEvaluator)Mockito.mock(ExpressionEvaluator.class, (Answer)new Answer<Boolean>(){
            int i = 0;

            public Boolean answer(InvocationOnMock invocation) throws Throwable {
                return mockAnswers[this.i++];
            }
        });
        process.setExpressionEvaluator(mockExpressionEvaluator);
        ArrayList<Node> childNodesSeq = new ArrayList<Node>();
        childNodesSeq.add(process.createNode("first", EmptyBehaviourImpl.class, null));
        childNodesSeq.add(process.createNode("second", EmptyBehaviourImpl.class, null));
        childNodesSeq.add(process.createNode("third", EmptyBehaviourImpl.class, null));
        Node sequence = CreationPatternFactory.getInstance().createSequencePattern("sequence", childNodesSeq, (Scope)process);
        ArrayList<Node> childNodesWhile = new ArrayList<Node>();
        childNodesWhile.add(sequence);
        Node initial = process.createNode("start", EmptyBehaviourImpl.class, null);
        Node while_ = CreationPatternFactory.getInstance().createLoopPattern("while", (Expression)condition, true, childNodesWhile, (Scope)process);
        Node end = process.createNode("end", EmptyBehaviourImpl.class, null);
        process.linkedBrotherNodes(initial, while_);
        process.linkedBrotherNodes(while_, end);
        process.setInitialNode(initial);
        Execution main = engine.run(process);
        this.checkExecutionEndedProperly(main);
    }
}

