/****************************************************************************
 *
 * Copyright (c) 2009-2012, EBM WebSourcing
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA 
 *
 *****************************************************************************/
 
package com.ebmwebsourcing.easyviper.core.impl.engine.variable;

import org.ow2.easywsdl.schema.api.abstractElmt.AbstractSchemaElementImpl;

import com.ebmwebsourcing.easyviper.core.api.engine.Execution;
import com.ebmwebsourcing.easyviper.core.api.engine.variable.Variable;
import com.ebmwebsourcing.easyviper.core.api.soa.message.MessageMatcher;

/**
 * @author Nicolas Salatge - EBM WebSourcing
 */
// TODO uncomment this line when viper annotations are ready
// @ChangedFields
public abstract class VariableImpl<T> extends AbstractSchemaElementImpl<T> implements
		Variable {

	/**
	 * 
	 */
	private static final long serialVersionUID = 1L;

	private MessageMatcher messageMatcher;

	public VariableImpl(T model, AbstractSchemaElementImpl<?> parent) {
		super(model, parent);
	}

	public VariableImpl() {
		super();
	}

	public abstract Object getValue(Execution execution);

	public abstract void assign(Execution execution, Object value);

	public MessageMatcher getMatcher() {
		return this.messageMatcher;
	}

	public void setMatcher(final MessageMatcher messageMatcher) {
		this.messageMatcher = messageMatcher;
	}

}
