/****************************************************************************
 *
 * Copyright (c) 2009-2012, EBM WebSourcing
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA 
 *
 *****************************************************************************/
 
package com.ebmwebsourcing.easyviper.core.impl.env;

import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;

import org.oasisopen.sca.annotation.PolicySets;
import org.oasisopen.sca.annotation.Reference;
import org.oasisopen.sca.annotation.Scope;
import org.objectweb.fractal.api.Component;
import org.objectweb.fractal.api.NoSuchInterfaceException;
import org.ow2.frascati.tinfi.api.control.ContentInstantiationException;
import org.ow2.frascati.tinfi.api.control.SCAContentController;

import com.ebmwebsourcing.easycommons.sca.helper.api.SCAException;
import com.ebmwebsourcing.easycommons.sca.helper.impl.SCAComponentImpl;
import com.ebmwebsourcing.easycommons.sca.helper.impl.SCAHelper;
import com.ebmwebsourcing.easyviper.core.api.Core;
import com.ebmwebsourcing.easyviper.core.api.CoreException;
import com.ebmwebsourcing.easyviper.core.api.engine.Engine;
import com.ebmwebsourcing.easyviper.core.api.env.ExternalEnvironment;
import com.ebmwebsourcing.easyviper.core.api.env.Receiver;
import com.ebmwebsourcing.easyviper.core.api.env.Sender;

/**
 * @author Nicolas Salatge - EBM WebSourcing
 */
@Scope("COMPOSITE")
@org.oasisopen.sca.annotation.Service(value=ExternalEnvironment.class,names="service")
@PolicySets("frascati:scaEasyCompositeWithContent")
public class ExternalEnvironmentImpl extends SCAComponentImpl implements ExternalEnvironment {

	/**
	 * 
	 */
	private static final long serialVersionUID = 1L;

	public static final String DEFAULT_EXTERNAL_ENVIRONMENT_NAME = "ExternalEnvironment";

	private Logger log = Logger.getLogger(ExternalEnvironmentImpl.class
			.getName());

	private final List<Component> receivers = new ArrayList<Component>();

	private final List<Component> senders = new ArrayList<Component>();

	@Reference(name="engine")
	private Engine engine;
	
	private String host;
	
	private String port;


	/**
	 * Default Constructor
	 * 
	 */
	public ExternalEnvironmentImpl() throws CoreException {
		super();
	}



	public Receiver addReceiver(final Class<? extends Receiver> receiverClass) throws CoreException {
		Receiver receiver = null;

		this.checkEngine();
		if (this.engine == null) {
			throw new CoreException(
					"You must create the engine before create an receiver!!!");
		}

		try {
		final Component fractalReceiver = SCAHelper.getSCAHelper()
				.createNewComponent(receiverClass.getName(), null);
		SCAHelper.getSCAHelper().addComponent(fractalReceiver,
				getComponent(), null);
		this.receivers.add(fractalReceiver);

		
			SCAContentController scacc = (SCAContentController)
				fractalReceiver.getFcInterface(SCAContentController.NAME);
			try {
				receiver = (Receiver) scacc.getFcContent();
			}
			catch (ContentInstantiationException e) {
				throw new CoreException(e);
			}
			if (!this.log.getName().equals(ExternalEnvironmentImpl.class.getName())) {
				receiver.setLog(this.log);
			}

			SCAHelper.getSCAHelper().startComponent(fractalReceiver);
			SCAHelper.getSCAHelper()
					.changeName(
							fractalReceiver,
							receiverClass.getSimpleName() + "_"
									+ this.receivers.size());

			receiver = (Receiver) fractalReceiver.getFcInterface("service");

		} catch (final NoSuchInterfaceException e) {
			throw new CoreException(e);
		} catch (final SCAException e) {
			throw new CoreException(e);
		}
		this.log.finest("receiver created and started");

		return receiver;
	}


	public List<Receiver> getReceivers() throws CoreException {
		final List<Receiver> res = new ArrayList<Receiver>();
		for (final Component comp : this.receivers) {
			try {
				res.add((Receiver) comp.getFcInterface("service"));
			} catch (final NoSuchInterfaceException e) {
				throw new CoreException(e);
			}
		}
		return res;
	}

	public Sender addSender(final Class<? extends Sender> senderClass) throws CoreException {
		Sender sender = null;

		this.checkEngine();
		if (this.engine == null) {
			throw new CoreException(
					"You must create the engine before create an sender!!!");
		}

		try {
		final Component fractalSender = SCAHelper.getSCAHelper()
				.createNewComponent(senderClass.getName(), null);
		SCAHelper.getSCAHelper().addComponent(fractalSender,
				getComponent(), null);
		this.senders.add(fractalSender);

	
//			sender = (Sender) fractalSender.getFcInterface("/content");
			SCAContentController scacc = (SCAContentController)
				fractalSender.getFcInterface(SCAContentController.NAME);
			try {
				sender = (Sender) scacc.getFcContent();
			}
			catch (ContentInstantiationException e) {
				throw new CoreException(e);
			}
//			sender.init(fractalSender);
			if (!this.log.getName().equals(ExternalEnvironmentImpl.class.getName())) {
				sender.setLog(this.log);
			}

			SCAHelper.getSCAHelper().startComponent(fractalSender);
			SCAHelper.getSCAHelper().changeName(fractalSender,
					senderClass.getSimpleName() + "_" + this.senders.size());

			sender = (Sender) fractalSender.getFcInterface("service");

		} catch (final NoSuchInterfaceException e) {
			throw new CoreException(e);
		} catch (final SCAException e) {
			throw new CoreException(e);
		}
		this.log.finest("sender created and started");

		return sender;
	}

	public List<Sender> getSenders() throws CoreException {
		final List<Sender> res = new ArrayList<Sender>();
		for (final Component comp : this.senders) {
			try {
				res.add((Sender) comp.getFcInterface("service"));
			} catch (final NoSuchInterfaceException e) {
				throw new CoreException(e);
			}
		}
		return res;
	}

	// TODO: Fix bug: unnessary methods
	private void checkEngine() throws CoreException {
		try {
			if (this.engine == null) {
				final Component coreComp = SCAHelper.getSCAHelper()
						.getParent(this.getComponent());
				final Core core = (Core) coreComp
						.getFcInterface("service");
				this.engine = core.getEngine();
			}
		} catch (final NoSuchInterfaceException e) {
			throw new CoreException(e);
		} catch (final SCAException e) {
			throw new CoreException(e);
		}
	}

	public Engine getEngine() {
		return this.engine;
	}

	public void setLog(final Logger logger) {
		this.log = logger;
	}



	@Override
	public String getHost() {
		return this.host;
	}



	@Override
	public void setHost(String host) {
		this.host = host;
	}



	@Override
	public String getPort() {
		return this.port;
	}



	@Override
	public void setPort(String port) {
		this.port = port;
	}
}
