/****************************************************************************
 *
 * Copyright (c) 2009-2012, EBM WebSourcing
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA 
 *
 *****************************************************************************/
 
package com.ebmwebsourcing.easyviper.core.impl.engine.behaviour.functionnal;

import java.util.List;

import org.oasisopen.sca.ServiceReference;
import org.objectweb.fractal.api.Component;

import com.ebmwebsourcing.easycommons.sca.helper.api.SCAException;
import com.ebmwebsourcing.easycommons.sca.helper.impl.SCAHelper;
import com.ebmwebsourcing.easyviper.core.api.CoreException;
import com.ebmwebsourcing.easyviper.core.api.engine.Execution;
import com.ebmwebsourcing.easyviper.core.api.engine.Node;
import com.ebmwebsourcing.easyviper.core.api.engine.behaviour.AbstractComplexBehaviourImpl;
import com.ebmwebsourcing.easyviper.core.api.engine.behaviour.functionnal.SequenceBehaviour;

/**
 * @author Nicolas Salatge - EBM WebSourcing
 */
@org.oasisopen.sca.annotation.Scope("COMPOSITE")
@org.oasisopen.sca.annotation.Service(value = SequenceBehaviour.class, names = "service")
public class SequenceBehaviourImpl extends AbstractComplexBehaviourImpl implements SequenceBehaviour {


    @Override
    protected State executeOnStarted(Execution execution) throws CoreException {
        try {
            final List<Node> childNodes = getNode().getChildNodes();
            if (!childNodes.isEmpty()) {

                // find first node
                Node firstNode = null;
                for (final Node node : childNodes) {

                    // start the node component
                    final Component nodeComp = SCAHelper.getSCAHelper().getComponentByInterface(
                            SCAHelper.getSCAHelper().getParent(this.getComponent()),
                            // (org.objectweb.fractal.api.Interface) node,
                            (ServiceReference<?>) node, "service");
                    if ((nodeComp != null) && (!SCAHelper.getSCAHelper().isStarted(nodeComp))) {
                        SCAHelper.getSCAHelper().startComponent(nodeComp);
                    }

                    if ((node.getIncomingNodes() == null)
                            || ((node.getIncomingNodes() != null) && (node.getIncomingNodes()
                                    .size() == 0))) {
                        firstNode = node;
                        break;
                    }
                }

                selectNextNodeToExecute(execution, firstNode);
            } 
        } catch (SCAException e) {
            throw new CoreException(e);
        }
        return State.ACTIVITY_ENDED;
    }
    
    
//    @Override
//    protected State executeOnStarted(Execution execution) {
//        // TODO Auto-generated method stub
//        return super.executeOnStarted(execution);
//    }
}
