/****************************************************************************
 *
 * Copyright (c) 2009-2012, EBM WebSourcing
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA 
 *
 *****************************************************************************/
 
package com.ebmwebsourcing.easyviper.core.impl.services;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Map.Entry;
import java.util.logging.Logger;

import javax.xml.namespace.QName;

import com.ebmwebsourcing.easyviper.core.api.CoreException;
import com.ebmwebsourcing.easyviper.core.api.engine.Engine;
import com.ebmwebsourcing.easyviper.core.api.engine.thread.service.AbstractServiceImpl;
import com.ebmwebsourcing.easyviper.core.api.env.ExternalContext;
import com.ebmwebsourcing.easyviper.core.api.services.AutoFlushMessageService;
import com.ebmwebsourcing.easyviper.core.api.soa.message.Message;

/**
 * @author Nicolas Salatge - EBM WebSourcing
 */
public class AutoFlushMessageServiceImpl extends AbstractServiceImpl implements
        AutoFlushMessageService {

    private Logger log = Logger.getLogger(AutoFlushMessageServiceImpl.class.getName());

    private final Map<QName, List<Map<Message, ExternalContext>>> messageRegistry = Collections
            .synchronizedMap(new HashMap<QName, List<Map<Message, ExternalContext>>>());

    public AutoFlushMessageServiceImpl(Engine engine) {
        super(engine);
    }

    public void run() {
        try {

            flushMessagesInRegistry();
            Thread.sleep(this.getRefreshFrequency());

        } catch (Exception e) {
            e.printStackTrace();
            log.severe("Error in auto trash service: " + e.getMessage());
        }
    }

    public void flushMessagesInRegistry() throws CoreException {
        this.log.finest("flush stored messages");
        List<Map<Message, ExternalContext>> allMsgs = new ArrayList<Map<Message, ExternalContext>>();
        for (final List<Map<Message, ExternalContext>> list : this.messageRegistry.values()) {
            allMsgs.addAll(list);
        }
        this.messageRegistry.clear();

        Iterator<Map<Message, ExternalContext>> itAllMsgs = allMsgs.iterator();
        while (itAllMsgs.hasNext()) {
            Map<Message, ExternalContext> msgMap = itAllMsgs.next();
            Iterator<Entry<Message, ExternalContext>> msgs = msgMap.entrySet().iterator();
            while (msgs.hasNext()) {
                Entry<Message, ExternalContext> entry = msgs.next();
                // this.getEngine().accept(entry.getKey(), entry
                // .getValue());
                Engine engine = this.getEngine();
                Message im = entry.getKey();
                ExternalContext ec = entry.getValue();
                engine.accept(im, ec);
            }
        }
    }

    public void addMessagesInRegistry(Message internalMessage, ExternalContext context) {
        QName internalMessageQName = internalMessage.getQName();
        List<Map<Message, ExternalContext>> msgs = this.messageRegistry.get(internalMessageQName);
        if (msgs == null) {
            msgs = new ArrayList<Map<Message, ExternalContext>>();
        }
        final Map<Message, ExternalContext> map = new HashMap<Message, ExternalContext>();
        map.put(internalMessage, context);
        msgs.add(map);
        this.messageRegistry.put(internalMessageQName, msgs);
    }
}
