/*
 * Decompiled with CFR 0.152.
 */
package com.ebmwebsourcing.easyviper.core.impl.engine.behaviour.functionnal;

import com.ebmwebsourcing.easycommons.lang.UncheckedException;
import com.ebmwebsourcing.easycommons.sca.helper.api.SCAException;
import com.ebmwebsourcing.easycommons.sca.helper.impl.SCAHelper;
import com.ebmwebsourcing.easycommons.uuid.SimpleUUIDGenerator;
import com.ebmwebsourcing.easyviper.core.api.engine.Engine;
import com.ebmwebsourcing.easyviper.core.api.engine.Execution;
import com.ebmwebsourcing.easyviper.core.api.engine.Node;
import com.ebmwebsourcing.easyviper.core.api.engine.Process;
import com.ebmwebsourcing.easyviper.core.api.engine.behaviour.AbstractComplexBehaviourImpl;
import com.ebmwebsourcing.easyviper.core.api.engine.behaviour.Behaviour;
import com.ebmwebsourcing.easyviper.core.api.engine.behaviour.functionnal.FlowBehaviour;
import com.ebmwebsourcing.easyviper.core.impl.engine.ExecutionImpl;
import com.ebmwebsourcing.easyviper.core.impl.engine.ExecutionThread;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;
import org.oasisopen.sca.annotation.Scope;
import org.oasisopen.sca.annotation.Service;
import org.objectweb.fractal.api.Component;
import org.objectweb.fractal.api.NoSuchInterfaceException;

@Scope(value="COMPOSITE")
@Service(value={FlowBehaviour.class}, names={"service"})
public class FlowBehaviourImpl
extends AbstractComplexBehaviourImpl
implements FlowBehaviour {
    private static final SimpleUUIDGenerator uuidGenerator = new SimpleUUIDGenerator();

    public static ExecutionThread startChildExecution(Process process, Execution parentExecution, Node childNode, SimpleUUIDGenerator uuidGenerator, Logger log) {
        Engine engine = process.getEngine();
        try {
            Component childExecutionComp = SCAHelper.getSCAHelper().createNewComponent(ExecutionImpl.class.getName(), null);
            Execution childExecution = (Execution)childExecutionComp.getFcInterface("service");
            SCAHelper.getSCAHelper().startComponent(childExecutionComp);
            SCAHelper.getSCAHelper().changeName(childExecutionComp, "exec_" + uuidGenerator.getNewID());
            childExecution.setStepByStep(parentExecution.isStepByStep());
            SCAHelper.getSCAHelper().addComponent(childExecutionComp, engine.getComponent(), null);
            SCAHelper.getSCAHelper().startComponent(childExecutionComp);
            parentExecution.addExecution(childExecution);
            childExecution.setInitialTarget(childNode);
            ExecutionThread executionThread = new ExecutionThread(childExecution, engine.getCore().getExternalEnvironment(), log);
            if (engine.getConfiguration().getSingleThreadedExecution()) {
                executionThread.run();
            } else {
                executionThread.start();
            }
            return executionThread;
        }
        catch (SCAException e) {
            e.printStackTrace();
            throw new UncheckedException((Throwable)e);
        }
        catch (NoSuchInterfaceException e) {
            e.printStackTrace();
            throw new UncheckedException((Throwable)e);
        }
    }

    protected Behaviour.State executeOnStarted(Execution execution) {
        List childNodes = this.getNode().getChildNodes();
        assert (childNodes != null);
        ArrayList<ExecutionThread> childExecutionThreads = new ArrayList<ExecutionThread>();
        for (Node childNode : childNodes) {
            ExecutionThread executionThread = FlowBehaviourImpl.startChildExecution(this.getNode().getProcess(), execution, childNode, uuidGenerator, this.log);
            childExecutionThreads.add(executionThread);
        }
        Process process = this.getNode().getProcess();
        Engine engine = process.getEngine();
        if (!engine.getConfiguration().getSingleThreadedExecution()) {
            for (Thread thread : childExecutionThreads) {
                try {
                    thread.join();
                }
                catch (InterruptedException e) {
                    throw new UncheckedException((Throwable)e);
                }
            }
        }
        this.selectNextNodeToExecute(execution, this.getNode());
        return Behaviour.State.ACTIVITY_ENDED;
    }
}

