/*
 * Decompiled with CFR 0.152.
 */
package com.ebmwebsourcing.easyviper.core.impl.engine.behaviour.functionnal;

import com.ebmwebsourcing.easyviper.core.api.Core;
import com.ebmwebsourcing.easyviper.core.api.CoreException;
import com.ebmwebsourcing.easyviper.core.api.engine.Execution;
import com.ebmwebsourcing.easyviper.core.api.engine.ExpressionEvaluator;
import com.ebmwebsourcing.easyviper.core.api.engine.Node;
import com.ebmwebsourcing.easyviper.core.api.engine.Process;
import com.ebmwebsourcing.easyviper.core.impl.AbstractCoreTest;
import com.ebmwebsourcing.easyviper.core.impl.TestExpressionImpl;
import com.ebmwebsourcing.easyviper.core.impl.engine.behaviour.functionnal.EmptyBehaviourImpl;
import com.ebmwebsourcing.easyviper.core.impl.engine.behaviour.functionnal.WaitBehaviourImpl;
import java.util.HashMap;
import javax.xml.namespace.QName;
import junit.framework.Assert;
import org.junit.Test;
import org.mockito.Mockito;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.stubbing.Answer;
import org.objectweb.fractal.api.NoSuchInterfaceException;

public class WaitBehaviourTest
extends AbstractCoreTest {
    @Test
    public void testWait() throws CoreException, NoSuchInterfaceException, InterruptedException {
        Core core = this.getCoreUnderTest();
        Process process = core.getEngine().createNewEmptyProcessInstance(new QName("waitProcess"), null);
        HashMap<String, TestExpressionImpl> context = new HashMap<String, TestExpressionImpl>();
        TestExpressionImpl exp = new TestExpressionImpl("'PT5S'");
        context.put("time", exp);
        Node initial = process.createNode("wait", WaitBehaviourImpl.class, context);
        process.setInitialNode(initial);
        ExpressionEvaluator mockExpressionEvaluator = (ExpressionEvaluator)Mockito.mock(ExpressionEvaluator.class, (Answer)new Answer(){

            public Object answer(InvocationOnMock invocation) throws Throwable {
                return "PT5S";
            }
        });
        process.setExpressionEvaluator(mockExpressionEvaluator);
        Node finalNode = process.createNode("empty", EmptyBehaviourImpl.class, null);
        process.linkedBrotherNodes(initial, finalNode);
        long start = System.currentTimeMillis();
        Execution main = core.getEngine().run(process);
        Assert.assertTrue((System.currentTimeMillis() - start > 5000L ? 1 : 0) != 0);
        this.checkExecutionEndedProperly(main);
    }
}

