/****************************************************************************
 *
 * Copyright (c) 2009-2012, EBM WebSourcing
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA 
 *
 *****************************************************************************/
 
package com.ebmwebsourcing.easyviper.core.impl.engine;

import java.util.logging.Level;
import java.util.logging.Logger;

import com.ebmwebsourcing.easycommons.lang.UncheckedException;
import com.ebmwebsourcing.easyviper.core.api.CoreException;
import com.ebmwebsourcing.easyviper.core.api.engine.Execution;
import com.ebmwebsourcing.easyviper.core.api.env.ExternalEnvironment;

/**
 * @author Marc Jambert - EBM WebSourcing
 */
public class ExecutionThread extends Thread {

    Logger log = Logger.getLogger(ExecutionThread.class.getSimpleName());

    private final Execution execution;

	private final ExternalEnvironment externalEnvironment;

    public ExecutionThread(Execution execution, ExternalEnvironment externalEnvironment, Logger logger) {
        super(execution.getName());
        this.execution = execution;
        this.externalEnvironment = externalEnvironment;
    }
    
    public Execution getExecution() {
		return execution;
	}

    @Override
    public void run() {
        try {
            if (execution.isStepByStep()) {
                execution.runStepByStep();
            } else {
                execution.run();
            }
        } catch (Exception e) {

            if (!(e instanceof CoreException)) {
                throw new UncheckedException(e);
            }

            if (execution.getParentExecution() == null) {
                // we are at top level ; no fault handler has been activated,
                // we should reply to client.

                // TODO : define notion of fault in viper and find back context
                // from it
                log.log(Level.INFO,
                        String.format(
                                "Fault occured during main '%s' (propagated upward, client notified!).",
                                execution.getName()), e);
                
                
                CoreException ce = (CoreException) e;
                if (!externalEnvironment.getSenders().isEmpty()) {
                    externalEnvironment.getSenders().get(0).sendTo((CoreException) e, this.execution.getCurrentScope().getProcess().getExternalContexts());
                }
                throw ce;
            } else {
                // we are in a child execution ; no fault handler has been
                // activated
                // (no local child fault handler nor global process fault
                // handler)
                // error is lost.
                log.log(Level.INFO,
                        String.format(
                                "Fault occured during execution of child execution '%s' (not propagated upward!).",
                                execution.getName()), e);
            }

        }
    }

}
