/****************************************************************************
 *
 * Copyright (c) 2009-2012, EBM WebSourcing
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA 
 *
 *****************************************************************************/
 
package com.ebmwebsourcing.easyviper.core.impl.engine.behaviour.functionnal;

import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;

import org.objectweb.fractal.api.Component;
import org.objectweb.fractal.api.NoSuchInterfaceException;

import com.ebmwebsourcing.easycommons.lang.UncheckedException;
import com.ebmwebsourcing.easycommons.sca.helper.api.SCAException;
import com.ebmwebsourcing.easycommons.sca.helper.impl.SCAHelper;
import com.ebmwebsourcing.easycommons.uuid.SimpleUUIDGenerator;
import com.ebmwebsourcing.easyviper.core.api.engine.Engine;
import com.ebmwebsourcing.easyviper.core.api.engine.Execution;
import com.ebmwebsourcing.easyviper.core.api.engine.Node;
import com.ebmwebsourcing.easyviper.core.api.engine.behaviour.AbstractComplexBehaviourImpl;
import com.ebmwebsourcing.easyviper.core.api.engine.behaviour.functionnal.FlowBehaviour;
import com.ebmwebsourcing.easyviper.core.impl.engine.ExecutionImpl;
import com.ebmwebsourcing.easyviper.core.impl.engine.ExecutionThread;

/**
 * @author Nicolas Salatge - EBM WebSourcing
 */
@org.oasisopen.sca.annotation.Scope("COMPOSITE")
@org.oasisopen.sca.annotation.Service(value = FlowBehaviour.class, names = "service")
public class FlowBehaviourImpl extends AbstractComplexBehaviourImpl implements FlowBehaviour {

    private static final SimpleUUIDGenerator uuidGenerator = new SimpleUUIDGenerator();

    public static ExecutionThread startChildExecution(com.ebmwebsourcing.easyviper.core.api.engine.Process process, Execution parentExecution, 
    		Node childNode, SimpleUUIDGenerator uuidGenerator, Logger log) {
        Engine engine = process.getEngine();
        try {

            Component childExecutionComp = SCAHelper.getSCAHelper().createNewComponent(
                    ExecutionImpl.class.getName(), null);
            Execution childExecution = (Execution) childExecutionComp.getFcInterface("service");
            SCAHelper.getSCAHelper().startComponent(childExecutionComp);
            SCAHelper.getSCAHelper().changeName(childExecutionComp, "exec_"+uuidGenerator.getNewID());

            childExecution.setStepByStep(parentExecution.isStepByStep());

            SCAHelper.getSCAHelper().addComponent(childExecutionComp, engine.getComponent(), null);
            SCAHelper.getSCAHelper().startComponent(childExecutionComp);

            parentExecution.addExecution(childExecution);

            // Add binding between execution and process
            childExecution.setInitialTarget(childNode);

            ExecutionThread executionThread = new ExecutionThread(childExecution, engine.getCore().getExternalEnvironment(), log); 

            if (engine.getConfiguration().getSingleThreadedExecution()) {
                executionThread.run();
            } else {
                executionThread.start();
            }
            return executionThread;
        } catch (SCAException e) {
            e.printStackTrace();
            throw new UncheckedException(e);
        } catch (NoSuchInterfaceException e) {
            e.printStackTrace();
            throw new UncheckedException(e);
        }
    }

    @Override
    protected State executeOnStarted(Execution execution) {
        List<Node> childNodes = getNode().getChildNodes();
        assert childNodes != null;

        List<Thread> childExecutionThreads = new ArrayList<Thread>();
        for (Node childNode : childNodes) {
            ExecutionThread executionThread = startChildExecution(getNode().getProcess(), execution, childNode, uuidGenerator, log);
            childExecutionThreads.add(executionThread);
        }
        
        com.ebmwebsourcing.easyviper.core.api.engine.Process process = getNode().getProcess();
        Engine engine = process.getEngine();
        if (!engine.getConfiguration().getSingleThreadedExecution()) {
            for (Thread thread : childExecutionThreads) {
                try {
                    thread.join();
                } catch (InterruptedException e) {
                    throw new UncheckedException(e);
                }
            }
        }

        selectNextNodeToExecute(execution, getNode());
        return State.ACTIVITY_ENDED;
    }

}
