/****************************************************************************
 *
 * Copyright (c) 2009-2012, EBM WebSourcing
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA 
 *
 *****************************************************************************/
 
package com.ebmwebsourcing.easyviper.core.impl.model.registry;

import java.util.logging.Logger;

import com.ebmwebsourcing.easyviper.core.api.model.registry.definition.ProcessContextDefinition;

/**
 * @author Nicolas Salatge - EBM WebSourcing
 */
public class ProcessContextDefinitionImpl implements ProcessContextDefinition {

	private static final int MAX_POOL_SIZE = 1000;

	int _poolsize;

	private final Logger log = Logger
			.getLogger(ProcessContextDefinitionImpl.class.getName());

	public ProcessContextDefinitionImpl(int poolsize) {
		setPoolSize(poolsize);
	}

	public ProcessContextDefinitionImpl() {
		this(1);
	}

	public int getPoolSize() {
		return _poolsize;
	}

	public void setPoolSize(int poolsize) {
		if (poolsize < 1) {
			this.log.warning("Minimum value for pool size is 1. Got "
					+ poolsize);
			_poolsize = 1;

		} else if (poolsize > MAX_POOL_SIZE) {

			this.log.warning("Maximum size reached for pool size: "
					+ MAX_POOL_SIZE);
			_poolsize = MAX_POOL_SIZE;

		} else {
			_poolsize = poolsize;
		}
	}
}
