/****************************************************************************
 *
 * Copyright (c) 2009-2012, EBM WebSourcing
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA 
 *
 *****************************************************************************/

package com.ebmwebsourcing.easyviper.core.impl.engine.pattern;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

import org.objectweb.fractal.api.Component;
import org.objectweb.fractal.api.NoSuchInterfaceException;
import org.ow2.frascati.tinfi.api.control.ContentInstantiationException;
import org.ow2.frascati.tinfi.api.control.SCAContentController;

import com.ebmwebsourcing.easycommons.sca.helper.api.SCAException;
import com.ebmwebsourcing.easycommons.sca.helper.impl.Binding;
import com.ebmwebsourcing.easycommons.sca.helper.impl.SCAHelper;
import com.ebmwebsourcing.easyviper.core.api.CoreException;
import com.ebmwebsourcing.easyviper.core.api.engine.Engine;
import com.ebmwebsourcing.easyviper.core.api.engine.Node;
import com.ebmwebsourcing.easyviper.core.api.engine.Scope;
import com.ebmwebsourcing.easyviper.core.api.engine.behaviour.Behaviour;
import com.ebmwebsourcing.easyviper.core.api.engine.behaviour.functionnal.ReceiverBehaviour;
import com.ebmwebsourcing.easyviper.core.api.engine.behaviour.functionnal.WaitBehaviour;
import com.ebmwebsourcing.easyviper.core.api.engine.expression.Expression;
import com.ebmwebsourcing.easyviper.core.api.soa.correlation.CorrelationMatcher;
import com.ebmwebsourcing.easyviper.core.api.soa.message.MessageMatcher;
import com.ebmwebsourcing.easyviper.core.impl.engine.NodeImpl;
import com.ebmwebsourcing.easyviper.core.impl.engine.ProcessImpl;
import com.ebmwebsourcing.easyviper.core.impl.engine.ScopeImpl;
import com.ebmwebsourcing.easyviper.core.impl.engine.behaviour.functionnal.ExclusiveBehaviourImpl;
import com.ebmwebsourcing.easyviper.core.impl.engine.behaviour.functionnal.FlowBehaviourImpl;
import com.ebmwebsourcing.easyviper.core.impl.engine.behaviour.functionnal.IfBehaviourImpl;
import com.ebmwebsourcing.easyviper.core.impl.engine.behaviour.functionnal.LoopBehaviourImpl;
import com.ebmwebsourcing.easyviper.core.impl.engine.behaviour.functionnal.ReceiverBehaviourImpl;
import com.ebmwebsourcing.easyviper.core.impl.engine.behaviour.functionnal.ScopeBehaviourImpl;
import com.ebmwebsourcing.easyviper.core.impl.engine.behaviour.functionnal.SequenceBehaviourImpl;

/**
 * @author Nicolas Salatge - EBM WebSourcing
 */
public class CreationPatternFactory {

	private static CreationPatternFactory instance;

	private CreationPatternFactory() {

	}

	public static CreationPatternFactory getInstance() {
		if (CreationPatternFactory.instance == null) {
			CreationPatternFactory.instance = new CreationPatternFactory();
		}
		return CreationPatternFactory.instance;
	}

	public Node createSequencePattern(final String name, final List<Node> childNodes,
			final Scope scope) throws CoreException {
		Node parentNode = null;
		try {
			if (scope == null) {
				throw new CoreException("scope cannot be null");
			}

			parentNode = scope.createNode(name, SequenceBehaviourImpl.class, null);

			if (childNodes != null) {
				// link nodes between them
				final Iterator<Node> it = childNodes.iterator();
				Node source = null;
				Node target = null;
				Node lastNode = null;
				Component sourceComp = null;
				Component targetComp = null;
				Component lastComp = null;

				while (it.hasNext()) {
					source = it.next();
					sourceComp = SCAHelper.getSCAHelper().getComponentByInterface(
							scope.getComponent(), (org.objectweb.fractal.api.Interface) source,
							"service");

					String sourceName = SCAHelper.getSCAHelper().getName(sourceComp);

					if (lastNode != null) {
						scope.linkedBrotherNodes(lastNode, source);
					}

					if (it.hasNext()) {

						target = it.next();
						targetComp = SCAHelper.getSCAHelper().getComponentByInterface(
								scope.getComponent(), (org.objectweb.fractal.api.Interface) target,
								"service");

						scope.linkedBrotherNodes(source, target);

						lastNode = target;
						lastComp = targetComp;
					} else {
						lastNode = null;
						lastComp = null;
					}
				}

				// link all children to parent
				if (childNodes != null) {
					for (final Node children : childNodes) {
						scope.linkedChildNodeToParent(parentNode, children);
					}
				}

			}
		} catch (SCAException e) {
			throw new CoreException(e);
		}
		return parentNode;
	}

	public com.ebmwebsourcing.easyviper.core.api.engine.Process createProcessPattern(final String name, Engine engine) {
		return (com.ebmwebsourcing.easyviper.core.api.engine.Process) doCreateScopePattern(name, ProcessImpl.class, engine.getComponent());
	}

	public Scope createScopePattern(final String name, final Scope parentScope) throws CoreException {
		assert parentScope != null;
		return (Scope) doCreateScopePattern(name, ScopeImpl.class, parentScope.getComponent());
	}

	private Node doCreateScopePattern(final String name, Class<?> scopeClass,
			final Component parentComponent) throws CoreException {
		Node underscope = null;
		try {
			final Component underscopeComp = SCAHelper.getSCAHelper().createNewComponent(
					scopeClass.getName(), null);

			// add scope in process
			SCAHelper.getSCAHelper().addComponent(underscopeComp, parentComponent, null);

			// underscope = (Scope) underscopeComp.getFcInterface("/content");
			SCAContentController scacc = (SCAContentController) underscopeComp
					.getFcInterface(SCAContentController.NAME);
			try {
				underscope = (Scope) scacc.getFcContent();
			} catch (ContentInstantiationException e) {
				throw new CoreException(e);
			}
			underscope.setName(name);

			// Start the scope
			SCAHelper.getSCAHelper().startComponent(underscopeComp);
			underscope = (Node) underscopeComp.getFcInterface("service");

			// create behaviour
			final Component fractalActivity = SCAHelper.getSCAHelper().createNewComponent(
					ScopeBehaviourImpl.class.getName(), null);
			SCAHelper.getSCAHelper().changeName(
					fractalActivity,
					ScopeBehaviourImpl.class.getSimpleName() + "4"
							+ SCAHelper.getSCAHelper().getName(underscopeComp));
			SCAHelper.getSCAHelper().addComponent(fractalActivity, parentComponent, null);
			SCAHelper.getSCAHelper().startComponent(fractalActivity);

			Behaviour behaviour = (Behaviour) fractalActivity.getFcInterface("service");
			linkNodeAndFunctionalBehaviour(parentComponent, underscope, behaviour);
			underscope.setActivity(behaviour);

		} catch (final NoSuchInterfaceException e) {
			throw new CoreException(e);
		} catch (final SCAException e) {
			throw new CoreException(e);
		}
		return underscope;
	}

	public Node createIfPattern(final String name, final List<Expression> expressions,
			final List<Node> childNodes, final Scope scope) throws CoreException {
		Node parentNode = null;

		if (scope == null) {
			throw new CoreException("scope cannot be null");
		}
		if ((expressions == null)
				|| (expressions.size() == 0)
				|| ((childNodes.size() == expressions.size()) && (childNodes.size() == expressions
				.size() + 1))) {
			throw new CoreException("Invalid if pattern");
		}

		// final IfBehaviour ifBehaviour = new IfBehaviourImpl();
		// ifBehaviour.setConditions(expressions);
		//
		Map<String, Object> context = new HashMap<String, Object>();
		context.put("conditions", expressions);
		parentNode = scope.createNode(name, IfBehaviourImpl.class, context);

		// link all children to parent
		if (childNodes != null) {
			for (final Node children : childNodes) {
				scope.linkedChildNodeToParent(parentNode, children);
			}
		}

		return parentNode;
	}


	public Node createLoopPattern(final String name, final Expression condition,
			final boolean applyConditionAtBegin, final List<Node> childNodes, final Scope scope)
					throws CoreException {
		Node parentNode = null;
		try {
			if (scope == null) {
				throw new CoreException("scope cannot be null");
			}

			if (condition == null) {
				throw new CoreException("condition cannot be null");
			}

			// final LoopBehaviour loopBehaviour = new LoopBehaviourImpl();
			// loopBehaviour.setCondition(condition);
			// loopBehaviour.setApplyConditionAtBegin(applyConditionAtBegin);
			Map<String, Object> context = new HashMap<String, Object>();
			context.put("condition", condition);
			context.put("applyConditionAtBegin", applyConditionAtBegin);
			parentNode = scope.createNode(name, LoopBehaviourImpl.class, context);

			if (childNodes != null) {
				// link nodes between them
				final Iterator<Node> it = childNodes.iterator();
				Node source = null;
				Node target = null;
				Node lastNode = null;
				Component sourceComp = null;
				Component targetComp = null;
				Component lastComp = null;
				String transitionName = "t";
				while (it.hasNext()) {
					source = it.next();
					sourceComp = SCAHelper.getSCAHelper().getComponentByInterface(
							scope.getComponent(), (org.objectweb.fractal.api.Interface) source,
							"service");

					if (lastNode != null) {
						scope.linkedBrotherNodes(lastNode, source);

					}

					if (it.hasNext()) {
						target = it.next();
						targetComp = SCAHelper.getSCAHelper().getComponentByInterface(
								scope.getComponent(), (org.objectweb.fractal.api.Interface) target,
								"service");

						scope.linkedBrotherNodes(source, target);

						lastNode = target;
						lastComp = targetComp;
					} else {
						lastNode = null;
						lastComp = null;
					}
				}

				// link all children to parent
				if (childNodes != null) {
					for (final Node children : childNodes) {
						scope.linkedChildNodeToParent(parentNode, children);
					}
				}
			}
		} catch (SCAException e) {
			throw new CoreException(e);
		}
		return parentNode;
	}

	public Node createFlowPattern(final String name, final List<Node> childNodes, final Scope scope)
			throws CoreException {
		Node parentNode = null;

		if (scope == null) {
			throw new CoreException("scope cannot be null");
		}

		parentNode = scope.createNode(name, FlowBehaviourImpl.class, null);

		// link all children to parent
		if (childNodes != null) {
			for (final Node children : childNodes) {
				scope.linkedChildNodeToParent2(parentNode, children);
			}
		}
		return parentNode;
	}

	public Node createExclusivePattern(final String name, final Map<Node, Node> childNodes,
			final Scope scope) throws CoreException {
		Node parentNode = null;

		if (scope == null) {
			throw new CoreException("scope cannot be null");
		}
		Map<String, Object> context = new HashMap<String, Object>();
		if (childNodes != null) {
			context.put("triggeringNodes", childNodes.keySet());
		}
		parentNode = scope.createNode(name, ExclusiveBehaviourImpl.class, context);

		// link children to parent
		if (childNodes != null) {
			// find waiting child nodes
			Map<WaitBehaviour, Node> waitingNodes = new HashMap<WaitBehaviour, Node>();
			for (Node child : childNodes.keySet()) {

				try {
					final Component comp = SCAHelper.getSCAHelper().getComponentByInterface(
							scope.getComponent(), (org.objectweb.fractal.api.Interface) child,
							"service");
					SCAHelper.getSCAHelper().startComponent(comp);
				} catch (SCAException e) {
					throw new CoreException(e);
				}

				if (child.getBehaviour() instanceof WaitBehaviour) {
					waitingNodes.put((WaitBehaviour) child.getBehaviour(), child);
				}
			}

			for (Node child : childNodes.keySet()) {
				scope.linkedChildNodeToParent(parentNode, child);

				Node follower = childNodes.get(child);
				if (follower != null) {
					// TODO
					// if(!follower.getOutgoingNodes().isEmpty()) {
					// throw new
					// CoreException("The exclusive pattern only admits a single node or a sequence pattern after its triggering behaviours.");
					// }
					try {
						scope.linkedChildNodeToParent(parentNode, follower);
					} catch(Exception e) {
						// do nothing
					}
				}
			}
		}
		return parentNode;
	}



	private static void linkNodeAndFunctionalBehaviour(Component parentComponent,
			final Node targetNode, final Behaviour behaviour) throws CoreException {
		try {
			if ((behaviour != null) && (targetNode != null)) {
				final Component targetComp = SCAHelper.getSCAHelper().getComponentByInterface(
						parentComponent, (org.objectweb.fractal.api.Interface) targetNode,
						"service");

				final Component activityComp = SCAHelper.getSCAHelper()
						.getComponentByInterface(parentComponent,
								(org.objectweb.fractal.api.Interface) behaviour, "service");

				if ((targetComp == null) || (activityComp == null)) {
					throw new CoreException("Impossible to link node to a transition");
				}

				// Add binding between target node and behaviour
				List<Binding> listOfBindings = new ArrayList<Binding>();
				listOfBindings.add(new Binding("behaviour",
						(org.objectweb.fractal.api.Interface) activityComp
						.getFcInterface("service")));
				SCAHelper.getSCAHelper().addBindings(targetComp, listOfBindings);

				// Add binding between behaviour and target node
				listOfBindings = new ArrayList<Binding>();
				listOfBindings
				.add(new Binding("node", (org.objectweb.fractal.api.Interface) targetComp
						.getFcInterface("service")));
				SCAHelper.getSCAHelper().addBindings(activityComp, listOfBindings);
			}
		} catch (final NoSuchInterfaceException e) {
			throw new CoreException(e);
		} catch (final SCAException e) {
			throw new CoreException(e);
		}
	}




}
