/*
 * Decompiled with CFR 0.152.
 */
package com.ebmwebsourcing.easyviper.core.impl.engine.behaviour.functionnal;

import com.ebmwebsourcing.easyviper.core.api.CoreException;
import com.ebmwebsourcing.easyviper.core.api.engine.Execution;
import com.ebmwebsourcing.easyviper.core.api.engine.behaviour.AbstractSimpleBehaviourImpl;
import com.ebmwebsourcing.easyviper.core.api.engine.behaviour.functionnal.AssignBehaviour;
import com.ebmwebsourcing.easyviper.core.api.engine.expression.AssignementExpression;
import com.ebmwebsourcing.easyviper.core.api.engine.expression.Assigner;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;
import org.oasisopen.sca.annotation.PolicySets;
import org.oasisopen.sca.annotation.Scope;
import org.oasisopen.sca.annotation.Service;
import org.osoa.sca.annotations.Property;

@Scope(value="COMPOSITE")
@Service(value={AssignBehaviour.class}, names={"service"})
@PolicySets(value={"frascati:scaEasyPrimitive"})
public class AssignBehaviourImpl
extends AbstractSimpleBehaviourImpl
implements AssignBehaviour {
    private Logger log = Logger.getLogger(AssignBehaviourImpl.class.getSimpleName());
    @Property(name="assignements", required=true)
    private List<AssignementExpression> assignements = new ArrayList<AssignementExpression>();

    protected void doExecute(Execution execution) {
        for (AssignementExpression assignement : this.assignements) {
            if (assignement == null || assignement.getLeft() == null) {
                throw new CoreException("The left assignement is null");
            }
            Assigner assigner = this.getNode().getProcess().getAssigner();
            if (assigner == null) {
                throw new CoreException("Error: the assigner cannot be null");
            }
            this.log.fine("set " + assignement.getRight() + " in " + assignement.getLeft());
            assigner.affect(execution, assignement.getLeft(), assignement.getRight());
        }
    }
}

