/*
 * Decompiled with CFR 0.152.
 */
package com.ebmwebsourcing.easyviper.core.impl.engine.behaviour.functionnal;

import com.ebmwebsourcing.easyviper.core.api.CoreException;
import com.ebmwebsourcing.easyviper.core.api.engine.Execution;
import com.ebmwebsourcing.easyviper.core.api.engine.Node;
import com.ebmwebsourcing.easyviper.core.api.engine.behaviour.AbstractComplexBehaviourImpl;
import com.ebmwebsourcing.easyviper.core.api.engine.behaviour.Behaviour;
import com.ebmwebsourcing.easyviper.core.api.engine.behaviour.functionnal.ReceiverBehaviour;
import com.ebmwebsourcing.easyviper.core.api.engine.variable.Variable;
import com.ebmwebsourcing.easyviper.core.api.soa.correlation.CorrelationMatcher;
import com.ebmwebsourcing.easyviper.core.api.soa.message.BindingInputMessageAdapter;
import com.ebmwebsourcing.easyviper.core.api.soa.message.BindingMessageAdapter;
import com.ebmwebsourcing.easyviper.core.api.soa.message.Message;
import com.ebmwebsourcing.easyviper.core.api.soa.message.MessageMatcher;
import java.util.ArrayList;
import java.util.List;
import javax.xml.namespace.QName;
import org.oasisopen.sca.annotation.Scope;
import org.oasisopen.sca.annotation.Service;
import org.osoa.sca.annotations.Property;

@Scope(value="COMPOSITE")
@Service(value={ReceiverBehaviour.class}, names={"service"})
public class ReceiverBehaviourImpl
extends AbstractComplexBehaviourImpl
implements ReceiverBehaviour {
    private Message message;
    @Property(name="variableName", required=true)
    private String variableName = null;
    @Property(name="messageMatcher", required=true)
    private MessageMatcher messageMatcher = null;
    @Property(name="correlationsMatcher", required=true)
    private List<CorrelationMatcher> correlationsMatcher = new ArrayList<CorrelationMatcher>();
    @Property(name="interfaceName", required=false)
    private QName interfaceName;
    @Property(name="inputMessageAdapter", required=false)
    private BindingInputMessageAdapter messageAdapter;
    private Node childNodeSelected = null;

    public boolean accept(Execution execution, Message message) throws CoreException {
        boolean accept = false;
        com.ebmwebsourcing.easyviper.core.api.engine.Scope scope = this.getNode().getScope();
        Variable v = scope.findVariable(this.variableName);
        if (v == null) {
            throw new CoreException("Impossible to find in process, the variable used in the received : " + this.getName());
        }
        boolean check = false;
        if (this.messageMatcher != null) {
            check = this.messageMatcher.match(v, message);
        } else {
            this.log.warning("no matcher found");
            check = true;
        }
        if (!check) {
            this.log.fine("message not valid for variable: " + this.variableName);
        } else {
            boolean correlationOK = false;
            if (this.correlationsMatcher != null && this.correlationsMatcher.size() > 0) {
                this.log.fine("Correlation found: execute correlation for receiver: " + this.getName());
                for (CorrelationMatcher corr : this.correlationsMatcher) {
                    correlationOK = corr.match(execution, this.variableName, message, this.messageAdapter, this.interfaceName);
                    if (!correlationOK) {
                        continue;
                    }
                    break;
                }
            } else {
                this.log.fine("No correlation ");
                correlationOK = true;
            }
            if (check && correlationOK) {
                boolean isBindingStyleRpc = this.messageAdapter.isBindingStyleRpc(message.getEndpoint(), message.getService(), this.interfaceName, message.getOperationName());
                this.messageAdapter.adaptFromBindingInput(execution, message, v, BindingMessageAdapter.Direction.REQUEST, isBindingStyleRpc);
                accept = true;
                this.selectNextNodeToExecute(execution, this.getNode());
                this.log.fine("Message accepted on receive by variable: " + this.variableName);
                if (!this.getNode().getChildNodes().isEmpty()) {
                    this.childNodeSelected = (Node)this.getNode().getChildNodes().get(0);
                }
            }
        }
        return accept;
    }

    public void setMessage(Message message) {
        this.message = message;
    }

    public Message getMessage() {
        return this.message;
    }

    public Node getChildNodeSelected() {
        return this.childNodeSelected;
    }

    private void executeOnSuspended(Execution execution) throws CoreException {
        if (this.message != null) {
            boolean accept = this.accept(execution, this.message);
            if (accept) {
                this.log.fine("Message accepted by the receive activity: " + this.getName());
                Node nextNode = this.notifyParentBehaviour(execution, this.getChildNodeSelected());
                if (nextNode == null) {
                    this.selectNextNodeToExecute(execution, this.getChildNodeSelected());
                } else {
                    this.selectNextNodeToExecute(execution, null);
                }
                execution.setStateRecursively(Execution.State.ACTIVE);
            } else {
                execution.setStateRecursively(Execution.State.SUSPENDED);
                this.log.fine("Message does not correspond - execution suspended: " + execution.getState());
                this.selectNextNodeToExecute(execution, this.getNode());
            }
            this.message = null;
        } else {
            execution.setStateRecursively(Execution.State.SUSPENDED);
            this.log.fine("No Message - execution suspended: " + execution.getState());
            this.selectNextNodeToExecute(execution, this.getNode());
        }
    }

    protected Behaviour.State executeOnInactive(Execution execution) throws CoreException {
        this.executeOnSuspended(execution);
        return Behaviour.State.ACTIVITY_STARTED;
    }

    protected Behaviour.State executeOnStarted(Execution execution) throws CoreException {
        if (this.message != null) {
            this.executeOnSuspended(execution);
            return Behaviour.State.ACTIVITY_STARTED;
        }
        return Behaviour.State.ACTIVITY_ENDED;
    }

    protected Behaviour.State executeOnEnded(Execution execution) throws CoreException {
        this.message = null;
        return super.executeOnEnded(execution);
    }
}

