/*
 * Decompiled with CFR 0.152.
 */
package com.ebmwebsourcing.easyviper.core.impl.services;

import com.ebmwebsourcing.easyviper.core.api.CoreException;
import com.ebmwebsourcing.easyviper.core.api.engine.Engine;
import com.ebmwebsourcing.easyviper.core.api.engine.thread.service.AbstractServiceImpl;
import com.ebmwebsourcing.easyviper.core.api.env.ExternalContext;
import com.ebmwebsourcing.easyviper.core.api.services.AutoFlushMessageService;
import com.ebmwebsourcing.easyviper.core.api.soa.message.Message;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import javax.xml.namespace.QName;

public class AutoFlushMessageServiceImpl
extends AbstractServiceImpl
implements AutoFlushMessageService {
    private Logger log = Logger.getLogger(AutoFlushMessageServiceImpl.class.getName());
    private final Map<QName, List<Map<Message, ExternalContext>>> messageRegistry = Collections.synchronizedMap(new HashMap());

    public AutoFlushMessageServiceImpl(Engine engine) {
        super(engine);
    }

    public void run() {
        try {
            this.flushMessagesInRegistry();
            Thread.sleep(this.getRefreshFrequency());
        }
        catch (Exception e) {
            e.printStackTrace();
            this.log.severe("Error in auto trash service: " + e.getMessage());
        }
    }

    public void flushMessagesInRegistry() throws CoreException {
        this.log.finest("flush stored messages");
        ArrayList<Map<Message, ExternalContext>> allMsgs = new ArrayList<Map<Message, ExternalContext>>();
        for (List<Map<Message, ExternalContext>> list : this.messageRegistry.values()) {
            allMsgs.addAll(list);
        }
        this.messageRegistry.clear();
        for (Map map : allMsgs) {
            for (Map.Entry entry : map.entrySet()) {
                Engine engine = this.getEngine();
                Message im = (Message)entry.getKey();
                ExternalContext ec = (ExternalContext)entry.getValue();
                engine.accept(im, ec);
            }
        }
    }

    public void addMessagesInRegistry(Message internalMessage, ExternalContext context) {
        QName internalMessageQName = internalMessage.getQName();
        List<Map<Message, ExternalContext>> msgs = this.messageRegistry.get(internalMessageQName);
        if (msgs == null) {
            msgs = new ArrayList<Map<Message, ExternalContext>>();
        }
        HashMap<Message, ExternalContext> map = new HashMap<Message, ExternalContext>();
        map.put(internalMessage, context);
        msgs.add(map);
        this.messageRegistry.put(internalMessageQName, msgs);
    }
}

