/**
 * easy VIPER software - Copyright (c) 2009 PetalsLink, 
 * http://www.petalslink.com/ 
 *  
 * This library is free software; you can redistribute it and/or modify it under 
 * the terms of the GNU Lesser General Public License as published by the Free 
 * Software Foundation; either version 2.1 of the License, or (at your option) 
 * any later version. This library is distributed in the hope that it will be 
 * useful, but WITHOUT ANY WARRANTY; without even the implied warranty of 
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU Lesser 
 * General Public License for more details. 
 *  
 * You should have received a copy of the GNU Lesser General Public License 
 * along with this library; if not, write to the Free Software Foundation, Inc., 
 * 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA 
 *  
 * ------------------------------------------------------------------------- 
 * $Id$ 
 * ------------------------------------------------------------------------- 
 */ 
package com.ebmwebsourcing.easyviper.environment.test.env;

import java.util.HashMap;
import java.util.logging.Logger;

import org.objectweb.fractal.api.Component;
import org.objectweb.fractal.api.NoSuchInterfaceException;
import org.ow2.frascati.tinfi.api.control.ContentInstantiationException;
import org.ow2.frascati.tinfi.api.control.SCAContentController;

import com.ebmwebsourcing.easycommons.sca.helper.api.SCAException;
import com.ebmwebsourcing.easycommons.sca.helper.impl.SCAHelper;
import com.ebmwebsourcing.easyviper.core.api.CoreException;
import com.ebmwebsourcing.easyviper.core.api.factory.AbstractFactoryImpl;
import com.ebmwebsourcing.easyviper.environment.test.env.api.ExecutionEnvironmentTest;
import com.ebmwebsourcing.easyviper.environment.test.env.impl.ExecutionEnvironmentTestImpl;

/**
 * This class is a concrete implementation of the abstract class BPELFactory.
 * Some ideas used here have been shamelessly copied from the wonderful JAXP and
 * Xerces work.
 *
 * @author Nicolas Salatge - eBM WebSourcing
 */
public class ExecutionEnvironmentTestFactoryImpl extends ExecutionEnvironmentTestFactory {


	private static Logger log = Logger.getLogger(AbstractFactoryImpl.class.getName());



	@Override
	public ExecutionEnvironmentTest newEnvironment(String name, boolean explorer) throws CoreException {
		ExecutionEnvironmentTest executionEnvironmentTest = null;
		Component executionEnvComponent = this.createExecutionEnvironmentTestComposite(explorer);
		try {
			SCAHelper.getSCAHelper().startComponent(executionEnvComponent);

			//(Model) (((SCAContentController)this.modelComponent.getFcInterface("/sca-content-controller")).getFcContent());

			executionEnvironmentTest = (ExecutionEnvironmentTest)((SCAContentController)executionEnvComponent.getFcInterface("/sca-content-controller")).getFcContent();
			//	((ExecutionEnvironmentTestImpl)executionEnvironmentTest).init(executionEnvComponent);

			if(name != null) {
				SCAHelper.getSCAHelper().changeName(executionEnvComponent, name);
			}

			executionEnvironmentTest = (ExecutionEnvironmentTest)((SCAContentController)executionEnvComponent.getFcInterface("/sca-content-controller")).getFcContent();
			//(ExecutionEnvironmentTest)executionEnvComponent.getFcInterface("/content");
		} catch (NoSuchInterfaceException e) {
			throw new CoreException(e);
		} catch (ContentInstantiationException e) {
			throw new CoreException(e);
		} catch (SCAException e) {
			throw new CoreException(e);
		}
		log.finest("core created and started");
		return executionEnvironmentTest;
	}


	/**
	 * Initialize core composite
	 *
	 * @throws CoreException
	 *
	 */
	private Component createExecutionEnvironmentTestComposite(boolean explorer) throws CoreException {
		Component executionEnvironmentTestComponent = null;
		try {
			if(!explorer) {
				executionEnvironmentTestComponent = SCAHelper.getSCAHelper()
				.createNewComponent(ExecutionEnvironmentTestImpl.class.getName(), null);
			}
			else {
				Component explorerComponent = SCAHelper.getSCAHelper()
				.createNewComponent("ExecutionEnvironmentTestExplorer", new HashMap<String, Object>());

				SCAHelper.getSCAHelper().startComponent(explorerComponent);
				Component explorerComp = SCAHelper.getSCAHelper().getComponents(explorerComponent).get(0);

				Component myExplorerComp = SCAHelper.getSCAHelper().getComponents(explorerComp).get(1);

				executionEnvironmentTestComponent = SCAHelper.getSCAHelper().getComponents(myExplorerComp).get(1);
			}
			SCAHelper.getSCAHelper().changeName(executionEnvironmentTestComponent, AbstractFactoryImpl.DEFAULT_FACTORY_NAME);
		} catch (SCAException e) {
			throw new CoreException(e);
		}
		return executionEnvironmentTestComponent;
	}	

}
