/****************************************************************************
 *
 * Copyright (c) 2009-2012, EBM WebSourcing
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA 
 *
 *****************************************************************************/
 
package com.ebmwebsourcing.easyviper.environment.test.env.impl;

import java.util.logging.Logger;

import org.oasisopen.sca.annotation.PolicySets;
import org.oasisopen.sca.annotation.Scope;
import org.objectweb.fractal.api.Component;
import org.objectweb.fractal.api.NoSuchInterfaceException;

import com.ebmwebsourcing.easycommons.sca.helper.api.SCAException;
import com.ebmwebsourcing.easycommons.sca.helper.impl.SCAComponentImpl;
import com.ebmwebsourcing.easycommons.sca.helper.impl.SCAHelper;
import com.ebmwebsourcing.easyviper.core.api.CoreException;
import com.ebmwebsourcing.easyviper.core.api.soa.message.Message;
import com.ebmwebsourcing.easyviper.environment.test.env.TestExternalContextImpl;
import com.ebmwebsourcing.easyviper.environment.test.env.api.ClientEndpoint;
import com.ebmwebsourcing.easyviper.environment.test.env.api.ExecutionEnvironmentTest;
import com.ebmwebsourcing.easyviper.environment.test.env.handler.TestTerminationHandler;

/**
 * @author Nicolas Salatge - EBM WebSourcing
 */
@Scope("COMPOSITE")
@org.oasisopen.sca.annotation.Service(value = ClientEndpoint.class, names = "service")
@PolicySets("frascati:scaEasyPrimitive")
public class ClientEndpointImpl extends SCAComponentImpl implements ClientEndpoint {

    private Logger log = Logger.getLogger(ClientEndpointImpl.class.getName());

    private Message response = null;

    private CoreException exception = null;
    
    private TestExternalContextImpl context = null;
    
    public ClientEndpointImpl() {
    	
    }
    
    public void init() {
    	context = new TestExternalContextImpl(this.getName(), new TestTerminationHandler());
    }

    public void send(Message message) throws CoreException {
        this.response = null;
        this.exception = null;
        log.finest("Message sended by the client: " + message);
        this.getExecutionEnvironmentTest()
                .getCore()
                .getExternalEnvironment()
                .getReceivers()
                .get(0)
                .accept(message, context);
    }

    public Message sendSync(Message message) throws CoreException {
        this.response = null;
        this.exception = null;
        log.finest("Message sended by the client: " + message);
        this.getExecutionEnvironmentTest()
                .getCore()
                .getExternalEnvironment()
                .getReceivers()
                .get(0)
                .accept(message, context);
        while ((response == null) && (exception == null)) {
            try {
                Thread.sleep(200);
            } catch (InterruptedException e) {
                // TODO Auto-generated catch block
                e.printStackTrace();
            }
        }

        if (exception != null) {
            throw exception;
        }

        return response;
    }

    public ExecutionEnvironmentTest getExecutionEnvironmentTest() throws CoreException {
        ExecutionEnvironmentTest res = null;
        try {
            Component execEnvComp = SCAHelper.getSCAHelper().getParent(this.getComponent());
            res = (ExecutionEnvironmentTest) execEnvComp.getFcInterface("service");
        } catch (NoSuchInterfaceException e) {
            throw new CoreException(e);
        } catch (SCAException e) {
            throw new CoreException(e);
        }
        return res;
    }

    public Message getResponse() {
        return this.response;
    }

    public void setResponse(Message message) {
        this.response = message;
    }

    public void setLog(Logger logger) {
        this.log = logger;
    }

    public void setException(CoreException exception) throws CoreException {
        this.exception = exception;
    }

    public CoreException getException() {
        return exception;
    }

}
