/*
 * Decompiled with CFR 0.152.
 */
package com.ebmwebsourcing.easyviper.environment.test.env.impl;

import com.ebmwebsourcing.easycommons.xml.XMLComparator;
import com.ebmwebsourcing.easyviper.core.api.CoreException;
import com.ebmwebsourcing.easyviper.core.api.soa.message.Message;
import com.ebmwebsourcing.easyviper.environment.test.env.api.Operation;
import com.ebmwebsourcing.easyviper.environment.test.env.api.Service;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;
import junit.framework.Assert;
import org.jdom.output.Format;
import org.jdom.output.XMLOutputter;

public class OperationImpl
implements Operation {
    private static Logger log = Logger.getLogger(OperationImpl.class.getName());
    private String name;
    private String pattern;
    private List<Operation.MessageExchangeInstances> meis = new ArrayList<Operation.MessageExchangeInstances>();
    private int successfulInvocation = 0;
    private int invocationNumber = 0;
    private Service service;

    public OperationImpl() {
    }

    public OperationImpl(String name, String pattern, Service service) {
        this.name = name;
        this.pattern = pattern;
        this.service = service;
    }

    @Override
    public synchronized Message execute(Message msg) throws CoreException {
        System.err.println("+++++++++++++++++++++++++++++++++++++++***********************");
        Message res = null;
        Operation.MessageExchangeInstances mei = null;
        ++this.invocationNumber;
        String actual = null;
        String expected = null;
        log.finest("actual msg BEFORE : \n" + msg.toString());
        if (msg.getBody().getPayload() != null) {
            actual = msg.toString();
        }
        log.finest("actual msg:\n" + actual);
        for (Operation.MessageExchangeInstances meiItem : this.meis) {
            expected = null;
            if (meiItem.getIn().getBody().getPayload() != null) {
                expected = meiItem.getIn().toString();
            }
            log.finest("expected msg:\n" + expected);
            if (actual == null && expected == null) {
                log.finest("Expected message is null ...");
                mei = meiItem;
                break;
            }
            log.finest("Comparison of the expected message and the actual one.");
            ByteArrayInputStream actualStream = new ByteArrayInputStream(actual.getBytes());
            ByteArrayInputStream expectedStream = new ByteArrayInputStream(expected.getBytes());
            try {
                if (!XMLComparator.isEquivalent((InputStream)expectedStream, (InputStream)actualStream)) continue;
                mei = meiItem;
                break;
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        if (mei == null) {
            Assert.fail((String)("no input message corresponding to " + actual + " in operation " + this.getName()));
        }
        this.meis.remove(mei);
        this.meis.add(mei);
        if (mei.getOut() != null) {
            res = mei.getOut();
        } else if (mei.getFault() != null) {
            CoreException ex = new CoreException();
            ex.setFault(mei.getFault());
            System.out.println("Send Message fault by partner:\n" + new XMLOutputter(Format.getPrettyFormat()).outputString(mei.getFault().getBody().getPayload()));
            throw ex;
        }
        ++this.successfulInvocation;
        return res;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getPattern() {
        return this.pattern;
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    @Override
    public void setPattern(String pattern) {
        this.pattern = pattern;
    }

    @Override
    public List<Operation.MessageExchangeInstances> getMessageExchangeInstances() {
        return this.meis;
    }

    @Override
    public void setMessageExchangeInstances(List<Operation.MessageExchangeInstances> mei) {
        this.meis = mei;
    }

    @Override
    public void addMessageExchangeInstances(Message in, Message out, Message fault) {
        this.meis.add(new MessageExchangeInstancesImpl(in, out, fault));
    }

    @Override
    public int getSuccessfulInvocation() {
        return this.successfulInvocation;
    }

    @Override
    public int getInvocationNumber() {
        return this.invocationNumber;
    }

    @Override
    public void clean() {
        this.successfulInvocation = 0;
        this.invocationNumber = 0;
    }

    @Override
    public Service getService() {
        return this.service;
    }

    @Override
    public void setService(Service service) {
        this.service = service;
    }

    public String toString() {
        return "OperationImpl [name=" + this.name + "]";
    }

    public class MessageExchangeInstancesImpl
    implements Operation.MessageExchangeInstances {
        public Message in;
        public Message out;
        public Message fault;

        public MessageExchangeInstancesImpl(Message in, Message out, Message fault) {
            this.in = in;
            this.out = out;
            this.fault = fault;
        }

        @Override
        public Message getFault() {
            return this.fault;
        }

        @Override
        public Message getIn() {
            return this.in;
        }

        @Override
        public Message getOut() {
            return this.out;
        }

        @Override
        public void setFault(Message msg) {
            this.fault = msg;
        }

        @Override
        public void setIn(Message msg) {
            this.in = msg;
        }

        @Override
        public void setOut(Message msg) {
            this.out = msg;
        }
    }
}

