/****************************************************************************
 *
 * Copyright (c) 2009-2012, EBM WebSourcing
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA 
 *
 *****************************************************************************/
 
package com.ebmwebsourcing.easyviper.environment.test.env;

import java.util.List;
import java.util.Map;
import java.util.logging.Logger;

import javax.xml.namespace.QName;

import org.oasisopen.sca.annotation.PolicySets;
import org.oasisopen.sca.annotation.Scope;
import org.oasisopen.sca.annotation.Service;
import org.objectweb.fractal.api.Component;
import org.objectweb.fractal.api.NoSuchInterfaceException;

import com.ebmwebsourcing.easycommons.sca.helper.api.SCAException;
import com.ebmwebsourcing.easycommons.sca.helper.impl.SCAHelper;
import com.ebmwebsourcing.easyviper.core.api.CoreException;
import com.ebmwebsourcing.easyviper.core.api.engine.Process;
import com.ebmwebsourcing.easyviper.core.api.env.ExternalContext;
import com.ebmwebsourcing.easyviper.core.api.env.Sender;
import com.ebmwebsourcing.easyviper.core.api.model.registry.ProcessKey;
import com.ebmwebsourcing.easyviper.core.api.model.registry.definition.ProcessDefinition;
import com.ebmwebsourcing.easyviper.core.api.soa.Partner;
import com.ebmwebsourcing.easyviper.core.api.soa.message.Message;
import com.ebmwebsourcing.easyviper.core.impl.engine.ProcessImpl;
import com.ebmwebsourcing.easyviper.core.impl.env.AbstractSenderImpl;
import com.ebmwebsourcing.easyviper.core.impl.model.registry.ProcessKeyImpl;
import com.ebmwebsourcing.easyviper.environment.test.env.api.ClientEndpoint;
import com.ebmwebsourcing.easyviper.environment.test.env.api.ExecutionEnvironmentTest;
import com.ebmwebsourcing.easyviper.environment.test.env.api.TestPartner;

/**
 * @author Nicolas Salatge - EBM WebSourcing
 */
@Scope("COMPOSITE")
@Service(value = Sender.class, names = "service")
@PolicySets("frascati:scaEasyPrimitive")
public class TestSenderImpl extends AbstractSenderImpl implements Sender {

    private static Logger log = Logger.getLogger(TestSenderImpl.class.getName());

    private static int internalClientCpt = 1;

    public ExecutionEnvironmentTest getExecutionEnvironmentTest() throws CoreException {
        ExecutionEnvironmentTest res = null;
        try {
            Component externalEnvComp = SCAHelper.getSCAHelper().getParent(this.getComponent());
            Component core = SCAHelper.getSCAHelper().getParent(externalEnvComp);
            Component executionEnvironment = SCAHelper.getSCAHelper().getParent(core);

            res = (ExecutionEnvironmentTest) executionEnvironment.getFcInterface("service");
        } catch (NoSuchInterfaceException e) {
            throw new CoreException(e);
        } catch (SCAException e) {
            throw new CoreException(e);
        }
        return res;
    }

    
    @Override
    public void sendTo(Message message, String address, Map<Partner, Map<String,ExternalContext>> context, boolean isReply) throws CoreException {
        String endpointName = message.getEndpoint();
        QName serviceName = message.getService();
        String operationName = message.getOperationName();

        if (message == null) {
            throw new CoreException("ASynchronous send: Message send to " + endpointName
                    + " on operation " + operationName
                    + " cannot be null. You must assign the variable associated to this message");
        }
        System.out.println("MESSAGE SENDED BY CORE to provider " + endpointName + ": \n"
                + message);

        if (endpointName == null) {
            throw new CoreException("the provider endpoint name cannot be null");
        }

        System.out.println("context : " + context);
        System.out.println("provider serviceName : " + serviceName);
        System.out.println("provider endpointName : " + endpointName);
        System.out.println("provider opertation" + operationName);

        /*
         * TODO need to be improved. The information used in a real environment
         * is the BPEL partner. As this is not defined here we assume that if
         * there is a process found for the message, it is dedicated to a BPEL
         * reply.
         */
        ProcessKey pk = new ProcessKeyImpl(null, serviceName, endpointName);
        List<Process> processes = this.getExternalEnvironment().getEngine()
                .getProcessInstanceRegistry().getProcessInstances(pk);

        if (processes.size() > 0) {
            findAndSendResponseToClient(message, context);
        } else {
            findAndExecuteProvider(message, endpointName);
        }

    }

    
    @Override
    public Message sendSyncTo(Message message, String address, Map<Partner, Map<String,ExternalContext>> context)
            throws CoreException {
        String endpointName = message.getEndpoint();
        QName serviceName = message.getService();
        String operationName = message.getOperationName();
        
        if (message == null) {
            throw new CoreException("Synchronous send: Message send to "
                    + endpointName + " on operation "
                    + operationName
                    + " cannot be null. You must assign the variable associated to this message");
        }
        System.out.println("RRRRRRRRRRRRRRR message.getQName() = " + message.getQName());

        System.out.println("MESSAGE SENDED SYNC BY CORE to provider "
                + endpointName + ": \n" + message);
        System.out.println("********* providerEndpoint.getEndpointName() = "
                + endpointName);
        System.out.println("********* providerEndpoint.getServiceName() = "
                + serviceName);

        Message responseMessage = findAndExecuteProvider(message, address);

        return responseMessage;
    }

    
    
    private Message findAndExecuteProvider(Message message, String address)
            throws CoreException {
        Message responseIfExist = null;
        String endpointName = message.getEndpoint();
        QName interfaceName = message.getInterface();
        QName serviceName = message.getService();
        String operationName = message.getOperationName();
        
        //try {
            // Find provider endpoint
            TestPartner provider = null;
            System.out.println("providerEndpoint.getEndpointName() = "
                    + endpointName);
            System.out.println("providerEndpoint.getAddress() = " + address);
            System.out
                    .println("this.getExecutionEnvironmentTest().getTestPartners().size() = "
                            + this.getExecutionEnvironmentTest().getTestPartners().size());
            System.out.println("this.getExecutionEnvironmentTest().getTestPartners() = "
                    + this.getExecutionEnvironmentTest().getTestPartners());

            // 1st possiblity everything is known from start in WSDL
            for (TestPartner providerItem : this.getExecutionEnvironmentTest()
                    .getTestPartners()) {
                System.out.println("************** providerItem = " + providerItem.getName());
                if (endpointName != null
                        && endpointName.equals(providerItem.getName())) {
                    provider = providerItem;
                    break;
                }
            }

            // 2nd case, address was set dynamically in BPEL
            if ((provider == null) && (address != null)) {
                // No external endpoint defined but it is a dynamic invocation
                // on
                // unknown endpoint
                // JUST FOR TEST: So, the end of http address must finish by an
                // known endpoint
                for (TestPartner providerItem : this.getExecutionEnvironmentTest()
                        .getTestPartners()) {
                    System.out.println("************** providerItem = " + providerItem.getName());
                    if (address != null
                            && address.endsWith(providerItem.getName())) {
                        provider = providerItem;
                        break;
                    }
                }
            }

            // 3rd possibility, we know only endpoint interface. We let the
            // external
            // environment find an appropriate
            // endpoint.
            if (provider == null && (interfaceName != null)) {
                for (TestPartner providerItem : this.getExecutionEnvironmentTest()
                        .getTestPartners()) {
                    System.out.println("************** providerItem = " + providerItem.getName());
                    if (interfaceName != null
                            && interfaceName.equals(
                                    providerItem.getMockService().getInterfaceName())) {
                        provider = providerItem;
                        break;
                    }
                }
            }

            System.out.println("PROCESS DEFINITION provider == " + provider);
            ProcessDefinition processDefinition = null;
            if (provider == null) {
                // Not external endpoint: Find if BPEL endpoint
                ProcessKey key = new ProcessKeyImpl(interfaceName,
                        serviceName, endpointName);
                processDefinition = (ProcessDefinition) this.getExecutionEnvironmentTest()
                        .getCore().getModel().getRegistry().getProcessDefinition(key);
                System.out.println("processDefinition1 == " + processDefinition);
                if (processDefinition == null) {
                    key = new ProcessKeyImpl(interfaceName,
                            serviceName, address);
                    processDefinition = (ProcessDefinition) this.getExecutionEnvironmentTest()
                            .getCore().getModel().getRegistry().getProcessDefinition(key);
                }
                System.out.println("processDefinition2 == " + processDefinition);

                if (processDefinition != null) {
                    // send message on a receiver of core
                    message.setEndpoint(endpointName);
                    message.setService(serviceName);
                    System.out.println("RRRRRRRRRRRRRRRRRRR externalMessage.getQName() = "
                            + message.getQName());

                    // // create internalClient
                    ClientEndpoint internalClient = this.getExecutionEnvironmentTest()
                            .createClientEndpoint(
                                    "internalClient" + TestSenderImpl.internalClientCpt);
                    TestSenderImpl.internalClientCpt++;
                    log.finest("Internal client created:  " + internalClient.getName());
                    System.out.println("Internal client created:  " + internalClient.getName());
                    responseIfExist = internalClient.sendSync(message);
                    System.out.println("MESSAGE RECEIVED BY CORE from " + internalClient.getName()
                            + " : \n" + responseIfExist);
                    log.finest("MESSAGE RECEIVED BY CORE from " + internalClient.getName()
                            + " : \n" + responseIfExist);
                    System.out.println("avant supression");
                    this.getExecutionEnvironmentTest().getClientEndpoints().remove(internalClient);
                    //SCAHelper.getSCAHelper().deleteComponent(internalClient.getComponent());
                    System.out.println("apres supression");

                } else {
                    log.severe("Impossible to find provider corresponding to this message: "
                            + message);
                    throw new CoreException(
                            "Impossible to find provider corresponding to this message: "
                                    + message);
                }
            } else {
                // Execute provider
                responseIfExist = provider.accept(message,
                        operationName);
                if (responseIfExist != null) {
                    System.out.println("MESSAGE RECEIVED BY CORE from "
                            + endpointName + " : \n" + responseIfExist);
                }
            }
        /*} catch (SCAException e) {
            throw new CoreException(e);
        }*/
        return responseIfExist;
    }

    private void findAndSendResponseToClient(Message externalMessage, Map<Partner, Map<String,ExternalContext>> context)
            throws CoreException {
    	System.out.println("In test context : "  + context);
        String clientName = ((TestExternalContextImpl) ProcessImpl.getFirstExternalContext(context)).getClientEndpointName();
        System.out.println("Client to send response: " + clientName);
        for (ClientEndpoint clientItem : this.getExecutionEnvironmentTest().getClientEndpoints()) {
            String name = clientItem.getName();

            if (clientName.equalsIgnoreCase(name)) {
                clientItem.setResponse(externalMessage);
                break;
            }

        }
    }

    private void findAndSendExceptionToClient(CoreException e, Map<Partner, Map<String,ExternalContext>> context)
            throws CoreException {

        String clientName = ((TestExternalContextImpl) ProcessImpl.getFirstExternalContext(context)).getClientEndpointName();
        for (ClientEndpoint clientItem : this.getExecutionEnvironmentTest().getClientEndpoints()) {
            String name = clientItem.getName();
            if (clientName.equalsIgnoreCase(name)) {
                clientItem.setException((CoreException) e);
                break;
            }
        }
    }

    public void sendTo(CoreException e, Map<Partner, Map<String,ExternalContext>> context) throws CoreException {
        this.findAndSendExceptionToClient(e, context);
    }

}
